package org.nakedobjects.runtime.memento;

import java.io.Serializable;

import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.Encodable;

class Data implements Encodable, Serializable {
	private final static long serialVersionUID = 1L;
	private final String className;
	private final String resolveState;
	private final Oid oid;

	public Data(final Oid oid, final String resolveState, final String className) {
		this.oid = oid;
		this.className = className;
		this.resolveState = resolveState;
	}

	public Data(final ByteDecoder decoder) {
		className = decoder.getString();
		resolveState = decoder.getString();
		oid = (Oid) decoder.getObject();
	}

	@Override
	public String toString() {
		return className + "/" + oid;
	}

	/**
	 * Note: could be <tt>null</tt> if represents a
	 * {@link ResolveState#isValue() standalone} adapter.
	 */
	public Oid getOid() {
		return oid;
	}

	public String getClassName() {
		return className;
	}

	public String getResolveState() {
		return resolveState;
	}

	public void encode(ByteEncoder encoder) {
		encoder.add(className);
		encoder.add(resolveState);
		encoder.add(oid);
	}

	public void debug(final DebugString debug) {
		debug.appendln(className);
		debug.appendln(oid != null ? oid.toString() : "null");
		debug.appendln(resolveState);
	}
}
// Copyright (c) Naked Objects Group Ltd.
