package org.nakedobjects.runtime.memento;

import java.io.Serializable;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public class StandaloneData extends Data {

	private static final long serialVersionUID = 1L;
	
	private static enum As {
		ENCODED_STRING,
		SERIALIZABLE
	}
	
	private String objectAsEncodedString;
	private Serializable objectAsSerializable;

	public StandaloneData(NakedObject adapter) {
		super(null, adapter.getResolveState().name(), adapter.getSpecification().getFullName());
		
		Object object = adapter.getObject();
		if (object instanceof Serializable) {
			this.objectAsSerializable = (Serializable) object;
			return;
		}
		
		EncodeableFacet encodeableFacet = adapter.getSpecification().getFacet(EncodeableFacet.class);
		if (encodeableFacet != null) {
			this.objectAsEncodedString = encodeableFacet.toEncodedString(adapter);
			return;
		}
		
		throw new IllegalArgumentException("Object wrapped by standalone adapter is not serializable and its specificatoin does not have an EncodeableFacet");
	}
	
	public void encode(ByteEncoder encoder) {
		super.encode(encoder);
		if(objectAsSerializable != null) {
			encoder.add(As.SERIALIZABLE);
			encoder.add(objectAsSerializable);
		} else {
			encoder.add(As.ENCODED_STRING);
			encoder.add(objectAsEncodedString);
		}
	}


	public StandaloneData(ByteDecoder decoder) {
		super(decoder);
		Object encodedAs = decoder.getObject();
		if (encodedAs.equals(As.SERIALIZABLE)) {
			this.objectAsSerializable = (Serializable) decoder.getObject();
		} else {
			this.objectAsEncodedString = decoder.getString();
		}
	}

	public NakedObject getAdapter() {
		if (objectAsSerializable != null) {
			return NakedObjectsContext.getPersistenceSession().getAdapterManager().adapterFor(objectAsSerializable);
		} else {
			NakedObjectSpecification spec = NakedObjectsContext.getSpecificationLoader().loadSpecification(getClassName());
			EncodeableFacet encodeableFacet = spec.getFacet(EncodeableFacet.class);
			return encodeableFacet.fromEncodedString(objectAsEncodedString);
		}
	}
	/**
	 * Either this or {@link #getObjectAsSerializable()} will be non-<tt>null</tt>.
	 * @return
	 */
	private String getObjectAsEncodedString() {
		return objectAsEncodedString;
	}
	
	/**
	 * Either this or {@link #getObjectAsEncodedString()} will be non-<tt>null</tt>.
	 * @return
	 */
	private Serializable getObjectAsSerializable() {
		return objectAsSerializable;
	}

}
