package org.nakedobjects.runtime.persistence.query;

import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;


public abstract class PersistenceQueryAbstract implements PersistenceQuery {
	
    private final NakedObjectSpecification specification;

    public PersistenceQueryAbstract(
    		final NakedObjectSpecification specification) {
    	this.specification = specification;
    }

    /**
     * provided for serialization purposes only.
     */
    protected PersistenceQueryAbstract() {
        specification = null;
    }

    protected final void doEncode(final ByteEncoder encoder) {}

    public NakedObjectSpecification getSpecification() {
        return specification;
    }

    @Override
    public int hashCode() {
        final int PRIME = 31;
        int result = 1;
        result = PRIME * result + 1231;
        result = PRIME * result + ((specification == null) ? 0 : specification.hashCode());
        return result;
    }

    @Override
    public boolean equals(final Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final PersistenceQueryAbstract other = (PersistenceQueryAbstract) obj;
        if (specification == null) {
            if (other.specification != null) {
                return false;
            }
        } else if (!specification.equals(other.specification)) {
            return false;
        }
        return true;
    }

}

// Copyright (c) Naked Objects Group Ltd.
