package org.nakedobjects.runtime.persistence.query;

import java.util.Collections;
import java.util.Map;

import org.nakedobjects.applib.query.Query;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.services.container.query.QueryCardinality;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;


/**
 * Corresponds to an object-store specific implementation of {@link Query}.
 */
public class PersistenceQueryFindUsingApplibQueryDefault extends PersistenceQueryAbstract {
	
	private String queryName;
	private Map<String, NakedObject> argumentsAdaptersByParameterName;
	private QueryCardinality cardinality;

    public PersistenceQueryFindUsingApplibQueryDefault(
    		final NakedObjectSpecification specification, 
    		final String queryName, 
    		final Map<String, NakedObject> argumentsAdaptersByParameterName, 
    		final QueryCardinality cardinality) {
        super(specification);
        this.queryName = queryName;
        this.argumentsAdaptersByParameterName = argumentsAdaptersByParameterName;
        this.cardinality = cardinality;
    }

    public String getQueryName() {
		return queryName;
	}
    
    public Map<String, NakedObject> getArgumentsAdaptersByParameterName() {
		return Collections.unmodifiableMap(argumentsAdaptersByParameterName);
	}
    
    public QueryCardinality getCardinality() {
		return cardinality;
	}
    
    @Override
    public String toString() {
        final ToString str = ToString.createAnonymous(this);
        str.append("spec", getSpecification().getShortName());
        return str.toString();
    }
}
// Copyright (c) Naked Objects Group Ltd.
