package org.nakedobjects.runtime.persistence.query;

import org.nakedobjects.applib.query.Query;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.services.container.query.QueryCardinality;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;


/**
 * Corresponds to an object-store specific implementation of {@link Query}.
 */
public class PersistenceQueryFindUsingApplibQuerySerializable extends PersistenceQueryAbstract {
	
    private final Query query;
	private QueryCardinality cardinality;

    public PersistenceQueryFindUsingApplibQuerySerializable(
    		final NakedObjectSpecification specification, 
    		final Query query, 
    		final QueryCardinality cardinality) {
        super(specification);
        this.query = query;
        this.cardinality = cardinality;
    }

    public Query getApplibQuery() {
        return query;
    }
    
    public QueryCardinality getCardinality() {
		return cardinality;
	}
    
    @Override
    public String toString() {
        final ToString str = ToString.createAnonymous(this);
        str.append("spec", getSpecification().getShortName());
        str.append("query", query.getDescription());
        return str.toString();
    }
}
// Copyright (c) Naked Objects Group Ltd.
