package org.nakedobjects.runtime.system;

/**
 * Whether running on client or server side etc.
 */
public enum DeploymentType {
    
    EXPLORATION       (true, false,  false, DeploymentCategory.EXPLORING),
    PROTOTYPE         (true, false,  false, DeploymentCategory.PROTOTYPING),
    STANDALONE        (true, false,  false, DeploymentCategory.PRODUCTION),
    CLIENT            (true, true,   false, DeploymentCategory.PRODUCTION),
    SERVER_EXPLORATION(false, false,  true,  DeploymentCategory.EXPLORING),
    SERVER_PROTOTYPE  (false, false,  true,  DeploymentCategory.PROTOTYPING),
    SERVER            (false, false,  true,  DeploymentCategory.PRODUCTION),
    UTILITY           (false, false,  false, DeploymentCategory.EXPLORING);

    private final boolean hasViewer;
    private final boolean isClientSideOnly;
    private final boolean isServerSideOnly;
    private final DeploymentCategory category;

    private DeploymentType(
    		final boolean hasViewer,
    		final boolean isClientSideOnly, 
            final boolean isServerSideOnly, 
            final DeploymentCategory category) {
    	this.hasViewer = hasViewer;
        this.isClientSideOnly = isClientSideOnly;
        this.isServerSideOnly = isServerSideOnly;
        this.category = category;
    }

    /**
     * Is strictly client-side (and therefore doesn't have an object store).
     */
    public boolean isClientSideOnly() {
        return isClientSideOnly;
    }

    public boolean isServerSideOnly() {
        return isServerSideOnly;
    }

    public boolean canSpecifyRemoting() {
        return isClientSideOnly() || isServerSideOnly();
    }

    public boolean hasViewer() {
        return hasViewer;
    }
    
    public boolean canSpecifyObjectStore() {
        //TODO: intend to rework this enumeration.
        //return isProduction() && !isClientSideOnly();
        return true;
    }

    public boolean isMultithreaded() {
        return isServerSideOnly() && isProduction();
    }

    public boolean isExploring() {
        return category == DeploymentCategory.EXPLORING;
    }

    public boolean isPrototyping() {
        return category == DeploymentCategory.PROTOTYPING;
    }

    public boolean isProduction() {
        return category == DeploymentCategory.PRODUCTION;
    }

    public boolean shouldMonitor() {
        return isServerSideOnly() && isProduction();
    }


}