package org.nakedobjects.runtime.system;

import org.nakedobjects.runtime.imageloader.TemplateImageLoader;
import org.nakedobjects.runtime.imageloader.awt.TemplateImageLoaderAwt;


/**
 * As its superclass, but provides a default for some of more basic components (that
 * is, where the core framework offers only a single implementation). 
 */
public abstract class NakedObjectsSystemDefault extends NakedObjectsSystemAbstract {
    

    /////////////////////////////////////////////
    // Constructor
    /////////////////////////////////////////////
    
    public NakedObjectsSystemDefault(DeploymentType deploymentType) {
        super(deploymentType);
    }

    
    /////////////////////////////////////////////
    // TemplateImageLoader
    /////////////////////////////////////////////

    /**
     * Required to show splash.
     * 
     * <p>
     * Just returns a {@link TemplateImageLoaderAwt}; subclasses may override if
     * required. 
     */
    protected TemplateImageLoader obtainTemplateImageLoader() {
        return new TemplateImageLoaderAwt(getConfiguration());
    }

}
// Copyright (c) Naked Objects Group Ltd.
