package org.nakedobjects.runtime.system.internal;

import java.io.File;

import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.nakedobjects.metamodel.config.ConfigurationConstants;
import org.nakedobjects.runtime.system.SystemConstants;

public class NakedObjectsLoggingInitializer {

    public static final Logger LOG = Logger.getLogger(NakedObjectsLoggingInitializer.class);

    /**
     * Sets up logging (if only temporarily) using either a logging file or (if cannot be
     * found) some sensible defaults.
     * 
     * <p>
     * If a {@link SystemConstants#LOGGING_CONFIG_FILE logging config file} can be located in the provided
     * directory, then that is used.  Otherwise, will set up the 
     * {@link Logger#getRootLogger() root logger} to {@link Level#WARN warning}, a
     * typical {@link PatternLayout} and logging to the {@link ConsoleAppender console}.
     * @param configDirectory TODO
     */
    public void configureLogging(final String configDirectory) {
        final File f = new File(configDirectory, SystemConstants.LOGGING_CONFIG_FILE);
        if (f.exists()) {
            PropertyConfigurator.configure(f.getAbsolutePath());
        } else {
            final Layout layout = new PatternLayout("%-5r [%-25.25c{1} %-10.10t %-5.5p]  %m%n");
            final Appender appender = new ConsoleAppender(layout);
            BasicConfigurator.configure(appender);
            Logger.getRootLogger().setLevel(Level.WARN);
            Logger.getLogger("ui").setLevel(Level.OFF);
        }
    }

    /**
     * As per {@link #configureLogging()}, and using {@link ConfigurationConstants#DIRECTORY} as the
     * directory.
     */
    public void configureLogging() {
        configureLogging(ConfigurationConstants.DIRECTORY);
    }

    
}


// Copyright (c) Naked Objects Group Ltd.
