package org.nakedobjects.runtime.authentication.standard;

import java.util.List;

import junit.framework.Assert;

import org.junit.Before;
import org.junit.Test;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.runtime.authentication.standard.MultiUserExplorationSession;


public class MultiUserExplorationSessionTest {

    private MultiUserExplorationSession session;

    @Before
    public void setUp() {
        session = new MultiUserExplorationSession("fred, sven:admin|sales|marketing, bob:sales, dick");
    }

    @Test
    public void testNameDefaultsToFirstUser() throws Exception {
        Assert.assertEquals("fred", session.getUserName());
    }

    @Test
    public void testNoValidateCode() throws Exception {
        Assert.assertEquals("", session.getValidationCode());
    }

    @Test
    public void testNoRolesSpecifiedForFirstUser() throws Exception {
        Assert.assertEquals(0, session.getRoles().length);
    }

    @Test
    public void testForMultipleUser() throws Exception {
        Assert.assertEquals(true, session.hasMultipleUsers());
    }

    @Test
    public void testForSingleUser() throws Exception {
        session = new MultiUserExplorationSession("sven");
        Assert.assertEquals(false, session.hasMultipleUsers());
        Assert.assertEquals("sven", session.getUserName());
    }

    @Test(expected = NakedObjectException.class)
    public void testNoUsersSpecified() throws Exception {
        new MultiUserExplorationSession("");
    }

    @Test
    public void testOtherUsers() throws Exception {
        List<String> availableSessions = session.getUserNames();
        Assert.assertEquals(4, availableSessions.size());
        Assert.assertTrue(availableSessions.contains("fred"));
        Assert.assertTrue(availableSessions.contains("sven"));
        Assert.assertTrue(availableSessions.contains("bob"));
        Assert.assertTrue(availableSessions.contains("dick"));
    }
    
    @Test
    public void testChangeUser() throws Exception {
        session.setCurrentSession("bob");
        Assert.assertEquals("bob", session.getUserName());
    }
    
    @Test
    public void testRolesExist() throws Exception {
        session.setCurrentSession("sven");
        String[] roles = session.getRoles();
        Assert.assertEquals(3, roles.length);
        Assert.assertEquals("admin", roles[0]);
        Assert.assertEquals("sales", roles[1]);
        Assert.assertEquals("marketing", roles[2]);
    }
}

// Copyright (c) Naked Objects Group Ltd.
