/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.memento;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.config.prop.PropertiesConfiguration;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.metamodel.specloader.NakedObjectReflector;
import org.nakedobjects.runtime.context.NakedObjectsContextStatic;
import org.nakedobjects.runtime.memento.Data;
import org.nakedobjects.runtime.memento.Memento;
import org.nakedobjects.runtime.memento.ObjectData;
import org.nakedobjects.runtime.memento.TestObject;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.session.NakedObjectSession;
import org.nakedobjects.runtime.session.NakedObjectSessionFactory;

public class MementoTest2 {
    private Mockery mockery = new JUnit4Mockery();
    private NakedObject rootAdapter;
    private NakedObject returnedAdapter;
    private TestObject rootObject;
    private TestObject recreatedObject;
    private Oid oid;
    private Data data;
    private Memento memento;

    @Before
    public void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        final NakedObjectSpecification rootSpecification = (NakedObjectSpecification)this.mockery.mock(NakedObjectSpecification.class);
        final OneToOneAssociation nameField = (OneToOneAssociation)this.mockery.mock(OneToOneAssociation.class);
        final NakedObjectSpecification nameSpecification = (NakedObjectSpecification)this.mockery.mock(NakedObjectSpecification.class, "name specification");
        final EncodeableFacet encodeableFacet = (EncodeableFacet)this.mockery.mock(EncodeableFacet.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectSpecification)this.atLeast(1).of((Object)rootSpecification)).isCollection();
                this.will(1.returnValue((Object)false));
                ((NakedObjectSpecification)this.atLeast(1).of((Object)rootSpecification)).getAssociations();
                this.will(1.returnValue((Object)new NakedObjectAssociation[]{nameField}));
                ((NakedObjectSpecification)this.atLeast(1).of((Object)rootSpecification)).getFullName();
                this.will(1.returnValue((Object)TestObject.class.getName()));
                ((OneToOneAssociation)this.atLeast(1).of((Object)nameField)).isNotDerived();
                this.will(1.returnValue((Object)true));
                ((OneToOneAssociation)this.atLeast(1).of((Object)nameField)).isOneToManyAssociation();
                this.will(1.returnValue((Object)false));
                ((OneToOneAssociation)this.atLeast(1).of((Object)nameField)).getSpecification();
                this.will(1.returnValue((Object)nameSpecification));
                ((OneToOneAssociation)this.atLeast(1).of((Object)nameField)).getId();
                this.will(1.returnValue((Object)"name-field"));
                ((NakedObjectSpecification)this.atLeast(1).of((Object)nameSpecification)).isEncodeable();
                this.will(1.returnValue((Object)true));
                ((NakedObjectSpecification)this.atLeast(1).of((Object)nameSpecification)).getFacet(EncodeableFacet.class);
                this.will(1.returnValue((Object)encodeableFacet));
            }
        });
        this.rootAdapter = (NakedObject)this.mockery.mock(NakedObject.class);
        this.rootObject = new TestObject("Harry");
        final NakedObject nameAdapter = (NakedObject)this.mockery.mock(NakedObject.class, "name");
        this.oid = (Oid)this.mockery.mock(Oid.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObject)this.atLeast(1).of((Object)MementoTest2.this.rootAdapter)).getSpecification();
                this.will(2.returnValue((Object)rootSpecification));
                ((NakedObject)this.atLeast(1).of((Object)MementoTest2.this.rootAdapter)).getOid();
                this.will(2.returnValue((Object)MementoTest2.this.oid));
                ((NakedObject)this.atLeast(1).of((Object)MementoTest2.this.rootAdapter)).getResolveState();
                this.will(2.returnValue((Object)ResolveState.RESOLVED));
                ((OneToOneAssociation)this.atLeast(1).of((Object)nameField)).get(MementoTest2.this.rootAdapter);
                this.will(2.returnValue((Object)nameAdapter));
                ((EncodeableFacet)this.one(encodeableFacet)).toEncodedString(nameAdapter);
                this.will(2.returnValue((Object)"_HARRY_"));
            }
        });
        this.mockery.checking((ExpectationBuilder)new Expectations(){});
        NakedObjectReflector reflector = (NakedObjectReflector)this.mockery.mock(NakedObjectReflector.class);
        PersistenceSession mockPersistenceSession = (PersistenceSession)this.mockery.mock(PersistenceSession.class);
        NakedObjectSessionFactory sessionFactory = (NakedObjectSessionFactory)this.mockery.mock(NakedObjectSessionFactory.class);
        AuthenticationSession mockSession = (AuthenticationSession)this.mockery.mock(AuthenticationSession.class);
        NakedObjectSession session = (NakedObjectSession)this.mockery.mock(NakedObjectSession.class);
        NakedObjectsContextStatic.createRelaxedInstance((NakedObjectSessionFactory)sessionFactory);
        this.memento = new Memento(this.rootAdapter);
        this.data = this.memento.getData();
    }

    @Test
    public void testOid() throws Exception {
        Assert.assertEquals((Object)this.oid, (Object)this.data.getOid());
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testResolved() throws Exception {
        Assert.assertEquals((Object)"Resolved", (Object)this.data.getResolveState());
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testClassName() throws Exception {
        Assert.assertEquals((Object)TestObject.class.getName(), (Object)this.data.getClassName());
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testStringField() throws Exception {
        Assert.assertEquals(ObjectData.class, this.data.getClass());
        Assert.assertEquals((Object)"_HARRY_", (Object)((ObjectData)this.data).getEntry("name-field"));
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testEncode() throws Exception {
        final ByteEncoder encoder = (ByteEncoder)this.mockery.mock(ByteEncoder.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((ByteEncoder)this.one(encoder)).add(TestObject.class.getName());
                ((ByteEncoder)this.one(encoder)).add(ResolveState.RESOLVED.name());
                ((ByteEncoder)this.one(encoder)).add((Object)MementoTest2.this.oid);
                ((ByteEncoder)this.one(encoder)).add(1);
                ((ByteEncoder)this.one(encoder)).add("S");
                ((ByteEncoder)this.one(encoder)).add("name-field");
                ((ByteEncoder)this.one(encoder)).add("_HARRY_");
            }
        });
        this.memento.encodedData(encoder);
        this.mockery.assertIsSatisfied();
    }
}

