/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.adapterfactory.pojo;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.runtime.persistence.ConcurrencyException;
import org.nakedobjects.runtime.persistence.adapterfactory.pojo.PojoAdapter;
import org.nakedobjects.runtime.testsystem.ProxyJunit3TestCase;
import org.nakedobjects.runtime.testsystem.TestPojo;
import org.nakedobjects.runtime.testsystem.TestProxyOid;
import org.nakedobjects.runtime.testsystem.TestProxyVersion;

public class PojoAdapterTest
extends ProxyJunit3TestCase {
    private NakedObject nakedObject;
    private TestPojo domainObject;

    protected void setUp() throws Exception {
        super.setUp();
        this.domainObject = new TestPojo();
        this.nakedObject = new PojoAdapter((Object)this.domainObject, (Oid)new TestProxyOid(1));
        this.nakedObject.setOptimisticLock((Version)new TestProxyVersion());
    }

    public void testOid() {
        PojoAdapterTest.assertEquals((Object)new TestProxyOid(1), (Object)this.nakedObject.getOid());
    }

    public void testObject() {
        PojoAdapterTest.assertEquals((Object)this.domainObject, (Object)this.nakedObject.getObject());
    }

    public void testInitialResolvedState() {
        PojoAdapterTest.assertEquals((Object)ResolveState.NEW, (Object)this.nakedObject.getResolveState());
    }

    public void testChangeResolvedState() {
        this.nakedObject.changeState(ResolveState.TRANSIENT);
        PojoAdapterTest.assertEquals((Object)ResolveState.TRANSIENT, (Object)this.nakedObject.getResolveState());
    }

    public void testVersion() throws Exception {
        PojoAdapterTest.assertEquals((Object)new TestProxyVersion(), (Object)this.nakedObject.getVersion());
    }

    public void testVersionConflict() throws Exception {
        try {
            this.nakedObject.checkLock((Version)new TestProxyVersion(2));
            PojoAdapterTest.fail();
        }
        catch (ConcurrencyException concurrencyException) {
            // empty catch block
        }
    }
}

