/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.objectstore;

import java.util.List;
import java.util.Vector;
import junit.framework.Assert;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.runtime.persistence.ObjectNotFoundException;
import org.nakedobjects.runtime.persistence.UnsupportedFindException;
import org.nakedobjects.runtime.persistence.objectstore.ObjectStore;
import org.nakedobjects.runtime.persistence.objectstore.ObjectStoreTransactionManagement;
import org.nakedobjects.runtime.persistence.objectstore.transaction.CreateObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.nakedobjects.runtime.persistence.query.PersistenceQuery;
import org.nakedobjects.runtime.transaction.NakedObjectTransaction;
import org.nakedobjects.runtime.transaction.ObjectPersistenceException;
import org.nakedobjects.runtime.transaction.PersistenceCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectStoreSpy
implements ObjectStore,
ObjectStoreTransactionManagement {
    private final Vector<String> actions = new Vector();
    private int instanceCount;
    private NakedObjectSpecification expectedClass;
    private NakedObject getObject;
    private NakedObject[] instances = null;
    private boolean hasInstances;

    public void open() throws ObjectPersistenceException {
    }

    public void close() {
    }

    public boolean isFixturesInstalled() {
        return true;
    }

    public void reset() {
        this.instanceCount = 0;
        this.actions.removeAllElements();
    }

    public void assertAction(int i, String expected) {
        Assert.assertTrue((String)("invalid action number " + i), (this.actions.size() > i ? 1 : 0) != 0);
        String actual = this.actions.elementAt(i);
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && actual.startsWith(expected)) {
            return;
        }
        Assert.fail((String)("action " + i + " expected: <" + expected + "> but was: <" + actual + ">"));
    }

    public void assertLastAction(int expectedLastAction) {
        int actualLastAction = this.actions.size() - 1;
        Assert.assertEquals((int)expectedLastAction, (int)actualLastAction);
    }

    public void abortTransaction() {
        this.actions.addElement("abortTransaction");
    }

    public void setupGetObject(NakedObject object) {
        this.getObject = object;
    }

    public void createNakedClass(NakedObject cls) throws ObjectPersistenceException {
    }

    public void endTransaction() {
        this.actions.addElement("endTransaction");
    }

    public Vector<String> getActions() {
        return this.actions;
    }

    public void debugData(DebugString debug) {
    }

    public String debugTitle() {
        return null;
    }

    public NakedObject getObject(Oid oid, NakedObjectSpecification hint) throws ObjectNotFoundException, ObjectPersistenceException {
        if (this.getObject == null) {
            Assert.fail((String)"no object expected");
        }
        Assert.assertEquals((Object)this.getObject.getOid(), (Object)oid);
        return this.getObject;
    }

    public Oid getOidForService(String name) {
        return null;
    }

    public void setupHasInstances(boolean flag) {
        this.hasInstances = flag;
    }

    public boolean hasInstances(NakedObjectSpecification cls) {
        return this.hasInstances;
    }

    public String name() {
        return null;
    }

    public void resolveImmediately(NakedObject object) {
    }

    public void resolveField(NakedObject object, NakedObjectAssociation field) throws ObjectPersistenceException {
    }

    public void setupInstancesCount(int i) {
        this.instanceCount = i;
    }

    public void setupInstances(NakedObject[] instances, NakedObjectSpecification cls) {
        this.instances = instances;
        this.expectedClass = cls;
    }

    public void startTransaction() {
        this.actions.addElement("startTransaction");
    }

    public NakedObject[] getInstances(PersistenceQuery criteria) throws ObjectPersistenceException, UnsupportedFindException {
        this.actions.addElement("getInstances " + criteria);
        return this.instances;
    }

    public CreateObjectCommand createCreateObjectCommand(final NakedObject object) {
        this.actions.addElement("createObject " + object);
        return new CreateObjectCommand(){

            public void execute(NakedObjectTransaction context) throws ObjectPersistenceException {
            }

            public String toString() {
                return "CreateObjectCommand " + object.toString();
            }

            public NakedObject onObject() {
                return object;
            }
        };
    }

    public DestroyObjectCommand createDestroyObjectCommand(final NakedObject object) {
        this.actions.addElement("destroyObject " + object);
        return new DestroyObjectCommand(){

            public void execute(NakedObjectTransaction context) throws ObjectPersistenceException {
            }

            public String toString() {
                return "DestroyObjectCommand " + object.toString();
            }

            public NakedObject onObject() {
                return object;
            }
        };
    }

    public SaveObjectCommand createSaveObjectCommand(final NakedObject object) {
        this.actions.addElement("saveObject " + object);
        return new SaveObjectCommand(){

            public void execute(NakedObjectTransaction context) throws ObjectPersistenceException {
            }

            public String toString() {
                return "DestroyObjectCommand " + object.toString();
            }

            public NakedObject onObject() {
                return object;
            }
        };
    }

    public void execute(List<PersistenceCommand> commands) throws ObjectPersistenceException {
        for (PersistenceCommand command : commands) {
            this.actions.addElement("execute " + command);
            command.execute(null);
        }
    }

    public void registerService(String name, Oid oid) {
    }
}

