/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.objectstore.algorithm.dflt;

import java.util.ArrayList;
import java.util.List;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.Persistability;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.testspec.TestProxySpecification;
import org.nakedobjects.runtime.persistence.NotPersistableException;
import org.nakedobjects.runtime.persistence.adapterfactory.pojo.PojoAdapter;
import org.nakedobjects.runtime.persistence.objectstore.algorithm.ToPersistObjectSet;
import org.nakedobjects.runtime.persistence.objectstore.algorithm.dflt.DefaultPersistAlgorithm;
import org.nakedobjects.runtime.persistence.oidgenerator.simple.SerialOid;
import org.nakedobjects.runtime.testspec.OneToOneAssociationTest;
import org.nakedobjects.runtime.testsystem.ProxyJunit3TestCase;
import org.nakedobjects.runtime.testsystem.TestProxyNakedObject;

public class DefaultPersistAlgorithmTest
extends ProxyJunit3TestCase {
    private DefaultPersistAlgorithm algorithm;
    private PersistedObjectAdderSpy adder;
    private NakedObject object;
    private TestProxyNakedObject fieldsObject;

    protected void setUp() throws Exception {
        super.setUp();
        this.algorithm = new DefaultPersistAlgorithm();
        this.object = this.system.createTransientTestObject();
        TestProxySpecification spec = this.system.getSpecification(this.object);
        NakedObjectAssociation[] fields = new NakedObjectAssociation[]{new OneToOneAssociationTest(){

            public void initAssociation(NakedObject inObject, NakedObject associate) {
            }

            public Consent isAssociationValid(NakedObject inObject, NakedObject associate) {
                return null;
            }

            public void setAssociation(NakedObject inObject, NakedObject associate) {
            }

            public void set(NakedObject owner, NakedObject newValue) {
            }

            public NakedObject get(NakedObject target) {
                return null;
            }

            public NakedObjectSpecification getSpecification() {
                return null;
            }

            public String debugData() {
                return null;
            }

            public String getId() {
                return null;
            }

            public String getName() {
                return null;
            }
        }};
        spec.setupFields(fields);
        this.fieldsObject = new TestProxyNakedObject();
        this.fieldsObject.setupResolveState(ResolveState.TRANSIENT);
        this.fieldsObject.setupSpecification((NakedObjectSpecification)this.system.getSpecification(String.class));
        this.adder = new PersistedObjectAdderSpy();
    }

    public void testMakePersistentFailsIfObjectAlreadyPersistent() {
        this.object.changeState(ResolveState.RESOLVED);
        try {
            this.algorithm.makePersistent(this.object, (ToPersistObjectSet)this.adder);
            DefaultPersistAlgorithmTest.fail();
        }
        catch (NotPersistableException notPersistableException) {
            // empty catch block
        }
    }

    public void testMakePersistentFailsIfObjectMustBeTransient() {
        try {
            this.system.getSpecification(this.object).setupPersistable(Persistability.TRANSIENT);
            this.algorithm.makePersistent(this.object, (ToPersistObjectSet)this.adder);
        }
        catch (NotPersistableException notPersistableException) {
            // empty catch block
        }
    }

    public void testMakePersistent() {
        this.algorithm.makePersistent(this.object, (ToPersistObjectSet)this.adder);
        DefaultPersistAlgorithmTest.assertEquals((Object)ResolveState.RESOLVED, (Object)this.object.getResolveState());
        DefaultPersistAlgorithmTest.assertTrue((boolean)this.adder.getPersistedObjects().contains(this.object));
    }

    public void testMakePersistentRecursesThroughReferenceFields() {
        this.algorithm.makePersistent(this.object, (ToPersistObjectSet)this.adder);
    }

    public void testMakePersistentRecursesThroughReferenceFieldsSkippingNullReferences() {
        this.algorithm.makePersistent(this.object, (ToPersistObjectSet)this.adder);
    }

    public void testMakePersistentRecursesThroughReferenceFieldsSkippingNonPersistentFields() {
        this.algorithm.makePersistent(this.object, (ToPersistObjectSet)this.adder);
    }

    public void testMakePersistentRecursesThroughReferenceFieldsSkippingObjectsThatAreAlreadyPersistent() {
        this.algorithm.makePersistent(this.object, (ToPersistObjectSet)this.adder);
    }

    public void testMakePersistentSkipsAggregatedObjects() {
        PojoAdapter aggregatedObject = new PojoAdapter(new Object(), (Oid)SerialOid.createTransient((long)1L));
        aggregatedObject.changeState(ResolveState.VALUE);
        class DefaultPersistAlgorithmSubclassForTesting
        extends DefaultPersistAlgorithm {
            DefaultPersistAlgorithmSubclassForTesting() {
            }

            protected void persist(NakedObject object, ToPersistObjectSet persistor) {
                super.persist(object, persistor);
            }

            public void sensingPersist(NakedObject object, ToPersistObjectSet persistor) {
                this.persist(object, persistor);
            }
        }
        new DefaultPersistAlgorithmSubclassForTesting().sensingPersist((NakedObject)aggregatedObject, this.adder);
        DefaultPersistAlgorithmTest.assertEquals((int)0, (int)this.adder.getPersistedObjects().size());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PersistedObjectAdderSpy
    implements ToPersistObjectSet {
        private final List<NakedObject> persistedObjects = new ArrayList<NakedObject>();

        private PersistedObjectAdderSpy() {
        }

        public List<NakedObject> getPersistedObjects() {
            return this.persistedObjects;
        }

        public void addPersistedObject(NakedObject object) {
            this.persistedObjects.add(object);
        }

        public void remapAsPersistent(NakedObject object) {
            object.changeState(ResolveState.RESOLVED);
        }
    }
}

