/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.oidgenerator.simple;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.runtime.persistence.oidgenerator.simple.SerialOid;

public class SerialOidDeString {
    @Test
    public void whenValidTransientWithPullsOutTransient() {
        SerialOid oid = SerialOid.deString((String)"TOID:1");
        Assert.assertThat((Object)oid.isTransient(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void whenValidWithNoPreviousThenNoPrevious() {
        SerialOid oid = SerialOid.deString((String)"TOID:1");
        Assert.assertThat((Object)oid.getPrevious(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void whenValidThenPullsOutSerialNumber() {
        SerialOid oid = SerialOid.deString((String)"TOID:1");
        Assert.assertThat((Object)oid.getSerialNo(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void whenValidTransientWithHexDigitsThenSerialNumberConverted() {
        SerialOid oid = SerialOid.deString((String)"TOID:2F");
        Assert.assertThat((Object)oid.getSerialNo(), (Matcher)CoreMatchers.is((Object)47L));
    }

    @Test
    public void whenValidTransientWithNonHexDigitsThenDigitsAreNeverthelessParsedAsHex() {
        SerialOid oid = SerialOid.deString((String)"TOID:10");
        Assert.assertThat((Object)oid.getSerialNo(), (Matcher)CoreMatchers.is((Object)16L));
    }

    @Test
    public void whenValidTransientWithBigHexDigitsThenConverted() {
        SerialOid oid = SerialOid.deString((String)"TOID:12ABF3");
        Assert.assertThat((Object)oid.getSerialNo(), (Matcher)CoreMatchers.is((Object)1223667L));
    }

    @Test
    public void whenValidPersistentThenPullsOutPersistent() {
        SerialOid oid = SerialOid.deString((String)"OID:1");
        Assert.assertThat((Object)oid.isTransient(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)oid.getSerialNo(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void whenValidPersistentWithBigHexDigitsThenPullsOutSerialNumber() {
        SerialOid oid = SerialOid.deString((String)"OID:12ABF3");
        Assert.assertThat((Object)oid.isTransient(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)oid.getSerialNo(), (Matcher)CoreMatchers.is((Object)1223667L));
    }

    @Test
    public void whenValidPersistentWithNoPreviousThenNoPrevious() {
        SerialOid oid = SerialOid.deString((String)"OID:12ABF3");
        Assert.assertThat((Object)oid.hasPrevious(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void whenValidPersistentWithTransientPreviousThenPullsOutPrevious() {
        SerialOid oid = SerialOid.deString((String)"OID:12ABF3~TOID:12");
        Assert.assertThat((Object)oid.hasPrevious(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void whenValidPersistentWithTransientPreviousThenPreviousDoesNotItselfHaveAPrevious() {
        SerialOid oid = SerialOid.deString((String)"OID:12ABF3~TOID:12");
        Oid previousOid = oid.getPrevious();
        Assert.assertThat((Object)previousOid.hasPrevious(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void whenValidPersistentWithTransientPreviousThenPreviousIsTransient() {
        SerialOid oid = SerialOid.deString((String)"OID:12ABF3~TOID:12");
        Oid previousOid = oid.getPrevious();
        Assert.assertThat((Object)previousOid.isTransient(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void whenValidPersistentWithPersistentPreviousThenPreviousIsPersistent() {
        SerialOid oid = SerialOid.deString((String)"TOID:12ABF3~OID:12");
        Oid previousOid = oid.getPrevious();
        Assert.assertThat((Object)previousOid.isTransient(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void whenValidPersistentWithPersistentPreviousThenPreviousSerialNumber() {
        SerialOid oid = SerialOid.deString((String)"OID:12ABF3~TOID:12");
        SerialOid previousOid = (SerialOid)oid.getPrevious();
        Assert.assertThat((Object)previousOid.getSerialNo(), (Matcher)CoreMatchers.is((Object)18L));
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenInvalidTransientModifierThrowsException() {
        SerialOid.deString((String)"QOID:12ABF3");
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenInvalidOidLiteralModifierThrowsException() {
        SerialOid.deString((String)"TOiD:12ABF3");
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenInvalidHexDigitsThrowsException() {
        SerialOid.deString((String)"TOID:1G");
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenInvalidPreviousConcatenationCharacterThrowsException() {
        SerialOid.deString((String)"OID:1F-OID#1A");
    }

    @Test
    public void shouldRoundtripOk() {
        SerialOid oid = SerialOid.createTransient((long)-9223372036854775807L);
        String enString = oid.enString();
        Assert.assertThat((Object)enString, (Matcher)CoreMatchers.is((Object)"TOID:-7FFFFFFFFFFFFFFF"));
        SerialOid oid2 = SerialOid.deString((String)enString);
        Assert.assertThat((Object)oid2.getSerialNo(), (Matcher)CoreMatchers.is((Object)oid.getSerialNo()));
        Assert.assertThat((Object)oid2.isTransient(), (Matcher)CoreMatchers.is((Object)oid.isTransient()));
    }
}

