/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.oidgenerator.simple;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.runtime.persistence.oidgenerator.simple.SerialOid;

public class SerialOidTest {
    @Test
    public void testEquals() {
        SerialOid oid1 = SerialOid.createTransient((long)123L);
        SerialOid oid2 = SerialOid.createTransient((long)123L);
        SerialOid oid3 = SerialOid.createTransient((long)321L);
        SerialOid oid4 = SerialOid.createPersistent((long)321L);
        SerialOid oid5 = SerialOid.createPersistent((long)456L);
        SerialOid oid6 = SerialOid.createPersistent((long)456L);
        Assert.assertTrue((boolean)oid1.equals(oid2));
        Assert.assertTrue((boolean)oid2.equals(oid1));
        Assert.assertFalse((boolean)oid1.equals(oid3));
        Assert.assertFalse((boolean)oid3.equals(oid1));
        Assert.assertTrue((boolean)oid5.equals(oid6));
        Assert.assertTrue((boolean)oid6.equals(oid5));
        Assert.assertFalse((boolean)oid4.equals(oid5));
        Assert.assertFalse((boolean)oid5.equals(oid4));
        Assert.assertFalse((boolean)oid3.equals((Object)oid4));
        Assert.assertFalse((boolean)oid4.equals((Object)oid3));
        Assert.assertFalse((boolean)oid3.equals(oid4));
        Assert.assertFalse((boolean)oid4.equals(oid3));
    }

    public void testHashCode() {
        SerialOid oid1 = SerialOid.createTransient((long)123L);
        SerialOid oid2 = SerialOid.createTransient((long)123L);
        SerialOid oid3 = SerialOid.createTransient((long)321L);
        SerialOid oid4 = SerialOid.createPersistent((long)321L);
        SerialOid oid5 = SerialOid.createPersistent((long)456L);
        SerialOid oid6 = SerialOid.createPersistent((long)456L);
        Assert.assertEquals((long)oid1.hashCode(), (long)oid2.hashCode());
        Assert.assertFalse((oid1.hashCode() == oid3.hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((long)oid5.hashCode(), (long)oid6.hashCode());
        Assert.assertFalse((oid4.hashCode() == oid5.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((oid3.hashCode() == oid4.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testCopy() {
        SerialOid oid1 = SerialOid.createTransient((long)123L);
        SerialOid oid3 = SerialOid.createTransient((long)321L);
        Assert.assertFalse((oid1.hashCode() == oid3.hashCode() ? 1 : 0) != 0);
        oid1.copyFrom((Oid)oid3);
        Assert.assertEquals((long)oid1.hashCode(), (long)oid3.hashCode());
    }

    @Test
    public void testStringAsHex() {
        Assert.assertEquals((Object)"TOID#7B", (Object)SerialOid.createTransient((long)123L).toString());
        Assert.assertEquals((Object)"OID#80", (Object)SerialOid.createPersistent((long)128L).toString());
    }

    @Test
    public void testMakePersistent() {
        SerialOid oid1 = SerialOid.createTransient((long)123L);
        Assert.assertNull((Object)oid1.getPrevious());
        oid1.setId(567L);
        oid1.makePersistent();
        Assert.assertEquals((long)567L, (long)oid1.getSerialNo());
        Assert.assertEquals((Object)false, (Object)oid1.isTransient());
        Assert.assertEquals((Object)oid1.getPrevious(), (Object)SerialOid.createTransient((long)123L));
    }

    @Test
    public void testGetPrevious() {
        SerialOid oid1 = SerialOid.createTransient((long)123L);
        Assert.assertNull((Object)oid1.getPrevious());
        SerialOid oidCopy = SerialOid.createTransient((long)0L);
        oidCopy.copyFrom((Oid)oid1);
        oid1.setId(567L);
        oid1.makePersistent();
        Assert.assertThat((Object)oid1.getPrevious().hashCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)oidCopy.hashCode())));
        Assert.assertThat((Object)oid1.getPrevious().equals(oidCopy), (Matcher)CoreMatchers.is((Object)true));
    }
}

