/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.system;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.When;
import org.nakedobjects.metamodel.facets.disable.DisableForSessionFacetAbstract;
import org.nakedobjects.metamodel.facets.hide.HiddenFacetAbstract;
import org.nakedobjects.metamodel.facets.hide.HiddenFacetAlways;
import org.nakedobjects.metamodel.facets.hide.HiddenFacetImpl;
import org.nakedobjects.metamodel.facets.hide.HiddenFacetNever;
import org.nakedobjects.metamodel.facets.hide.HideForContextFacetNone;
import org.nakedobjects.metamodel.facets.hide.HideForSessionFacetAbstract;
import org.nakedobjects.metamodel.facets.naming.describedas.DescribedAsFacetAbstract;
import org.nakedobjects.metamodel.facets.naming.named.NamedFacetAbstract;
import org.nakedobjects.runtime.system.NakedObjectMemberAbstractImpl;
import org.nakedobjects.runtime.testsystem.TestProxySystem;

public class NakedObjectMemberAbstractTest {
    private TestProxySystem system;
    private NakedObjectMemberAbstractImpl testMember;
    private NakedObject testAdapter;

    @Before
    public void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        this.system = new TestProxySystem();
        this.system.init();
        this.testAdapter = this.system.createPersistentTestObject();
        this.testMember = new NakedObjectMemberAbstractImpl("id");
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testToString() throws Exception {
        this.testMember.addFacet((Facet)new NamedFacetAbstract("", (FacetHolder)this.testMember){});
        Assert.assertTrue((this.testMember.toString().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAvailableForUser() throws Exception {
        this.testMember.addFacet((Facet)new DisableForSessionFacetAbstract((FacetHolder)this.testMember){

            public String disabledReason(AuthenticationSession session) {
                return null;
            }
        });
        Consent usable = this.testMember.isUsable(null, this.testAdapter);
        boolean allowed = usable.isAllowed();
        Assert.assertTrue((boolean)allowed);
    }

    @Test
    public void testVisibleWhenHiddenFacetSetToAlways() {
        this.testMember.addFacet((Facet)new HideForContextFacetNone((FacetHolder)this.testMember));
        this.testMember.addFacet((Facet)new HiddenFacetAbstract(When.ALWAYS, (FacetHolder)this.testMember){

            public String hiddenReason(NakedObject target) {
                return null;
            }
        });
        Consent visible = this.testMember.isVisible(null, this.testAdapter);
        Assert.assertTrue((boolean)visible.isAllowed());
    }

    @Test
    public void testVisibleWhenTargetPersistentAndHiddenFacetSetToOncePersisted() {
        this.testMember.addFacet((Facet)new HideForContextFacetNone((FacetHolder)this.testMember));
        this.testMember.addFacet((Facet)new HiddenFacetImpl(When.ONCE_PERSISTED, (FacetHolder)this.testMember));
        Assert.assertFalse((boolean)this.testMember.isVisible(null, this.testAdapter).isAllowed());
    }

    @Test
    public void testVisibleWhenTargetPersistentAndHiddenFacetSetToUntilPersisted() {
        this.testMember.addFacet((Facet)new HideForContextFacetNone((FacetHolder)this.testMember));
        this.testMember.addFacet((Facet)new HiddenFacetImpl(When.UNTIL_PERSISTED, (FacetHolder)this.testMember));
        Consent visible = this.testMember.isVisible(null, this.testAdapter);
        Assert.assertTrue((boolean)visible.isAllowed());
    }

    @Test
    public void testVisibleWhenTargetTransientAndHiddenFacetSetToUntilPersisted() {
        this.testMember.addFacet((Facet)new HideForContextFacetNone((FacetHolder)this.testMember));
        this.testMember.addFacet((Facet)new HiddenFacetImpl(When.UNTIL_PERSISTED, (FacetHolder)this.testMember));
        NakedObject transientTestAdapter = this.system.createTransientTestObject();
        Assert.assertFalse((boolean)this.testMember.isVisible(null, transientTestAdapter).isAllowed());
    }

    @Test
    public void testVisibleDeclarativelyByDefault() {
        this.testMember.addFacet((Facet)new HiddenFacetNever((FacetHolder)this.testMember){});
        Assert.assertTrue((boolean)this.testMember.isVisible(null, this.testAdapter).isAllowed());
    }

    @Test
    public void testVisibleDeclaratively() {
        this.testMember.addFacet((Facet)new HiddenFacetAlways((FacetHolder)this.testMember){});
        Assert.assertFalse((boolean)this.testMember.isVisible(null, this.testAdapter).isAllowed());
    }

    @Test
    public void testVisibleForSessionByDefault() {
        Consent visible = this.testMember.isVisible(null, this.testAdapter);
        Assert.assertTrue((boolean)visible.isAllowed());
    }

    @Test
    public void testVisibleForSession() {
        this.testMember.addFacet((Facet)new HideForSessionFacetAbstract((FacetHolder)this.testMember){

            public String hiddenReason(AuthenticationSession session) {
                return "Hidden";
            }
        });
        Assert.assertFalse((boolean)this.testMember.isVisible(null, this.testAdapter).isAllowed());
    }

    @Test
    public void testVisibleForSessionFails() {
        this.testMember.addFacet((Facet)new HideForSessionFacetAbstract((FacetHolder)this.testMember){

            public String hiddenReason(AuthenticationSession session) {
                return "hidden";
            }
        });
        Assert.assertFalse((boolean)this.testMember.isVisible(null, this.testAdapter).isAllowed());
    }

    @Test
    public void testName() throws Exception {
        String name = "action name";
        this.testMember.addFacet((Facet)new NamedFacetAbstract("action name", (FacetHolder)this.testMember){});
        Assert.assertEquals((Object)"action name", (Object)this.testMember.getName());
    }

    @Test
    public void testDescription() throws Exception {
        String name = "description text";
        this.testMember.addFacet((Facet)new DescribedAsFacetAbstract("description text", (FacetHolder)this.testMember){});
        Assert.assertEquals((Object)"description text", (Object)this.testMember.getDescription());
    }
}

