/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.testsystem;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacetDefaultToObject;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.specloader.NakedObjectReflector;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.testspec.TestProxySpecification;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.authentication.noop.AuthenticationManagerNoop;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.context.NakedObjectsContextStatic;
import org.nakedobjects.runtime.imageloader.TemplateImageLoader;
import org.nakedobjects.runtime.imageloader.TemplateImageLoaderNoop;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.persistence.adapterfactory.AdapterFactory;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerPersist;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerTestSupport;
import org.nakedobjects.runtime.persistence.internal.RuntimeContextFromSession;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGenerator;
import org.nakedobjects.runtime.session.NakedObjectSessionDefault;
import org.nakedobjects.runtime.session.NakedObjectSessionFactory;
import org.nakedobjects.runtime.session.NakedObjectSessionFactoryDefault;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.testsystem.TestPojo;
import org.nakedobjects.runtime.testsystem.TestProxyCollectionFacet;
import org.nakedobjects.runtime.testsystem.TestProxyConfiguration;
import org.nakedobjects.runtime.testsystem.TestProxyNakedCollection;
import org.nakedobjects.runtime.testsystem.TestProxyNakedObject;
import org.nakedobjects.runtime.testsystem.TestProxyOid;
import org.nakedobjects.runtime.testsystem.TestProxyPersistenceSession;
import org.nakedobjects.runtime.testsystem.TestProxyPersistenceSessionFactory;
import org.nakedobjects.runtime.testsystem.TestProxyReflector;
import org.nakedobjects.runtime.testsystem.TestProxySession;
import org.nakedobjects.runtime.testsystem.TestProxyVersion;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifier;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifierDefault;
import org.nakedobjects.runtime.userprofile.UserProfileLoader;
import org.nakedobjects.runtime.userprofile.UserProfileLoaderDefault;
import org.nakedobjects.runtime.userprofile.UserProfileStore;
import org.nakedobjects.runtime.userprofile.inmemory.InMemoryUserProfileStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestProxySystem {
    private int nextId = 1;
    private final TestProxyConfiguration configuration;
    private NakedObjectsContext context;
    private UserProfileLoader userProfileLoader;
    private UserProfileStore userprofileStore;
    private TestProxyPersistenceSessionFactory persistenceSessionFactory;
    private PersistenceSession persistenceSession;
    private final TestProxyReflector reflector;
    private final UpdateNotifierDefault updateNotifier;
    private final TemplateImageLoader noopTemplateImageLoader = new TemplateImageLoaderNoop();
    protected AuthenticationManager authenticationManager;
    private List<Object> servicesList;

    public TestProxySystem() {
        this.reflector = new TestProxyReflector();
        this.servicesList = Collections.emptyList();
        this.persistenceSessionFactory = new TestProxyPersistenceSessionFactory();
        this.userprofileStore = new InMemoryUserProfileStore();
        this.userProfileLoader = new UserProfileLoaderDefault(this.userprofileStore, UserProfileLoaderDefault.Mode.RELAXED);
        this.persistenceSession = new TestProxyPersistenceSession(this.persistenceSessionFactory);
        this.persistenceSessionFactory.setPersistenceSessionToCreate(this.persistenceSession);
        this.configuration = new TestProxyConfiguration();
        this.configuration.add("nakedobjects.locale", "en_GB");
        this.authenticationManager = new AuthenticationManagerNoop();
        this.updateNotifier = new UpdateNotifierDefault();
    }

    public TestProxyNakedObject createAdapterForTransient(Object associate) {
        TestProxyNakedObject testProxyNakedObject = new TestProxyNakedObject();
        testProxyNakedObject.setupObject(associate);
        testProxyNakedObject.setupSpecification((NakedObjectSpecification)this.getSpecification(associate.getClass()));
        testProxyNakedObject.setupResolveState(ResolveState.TRANSIENT);
        testProxyNakedObject.setupOid(new TestProxyOid(this.nextId++));
        return testProxyNakedObject;
    }

    public void init() {
        this.reflector.setRuntimeContext((RuntimeContext)new RuntimeContextFromSession());
        NakedObjectSessionFactoryDefault sessionFactory = new NakedObjectSessionFactoryDefault(DeploymentType.EXPLORATION, (NakedObjectConfiguration)this.configuration, this.noopTemplateImageLoader, (SpecificationLoader)this.reflector, this.authenticationManager, this.userProfileLoader, (PersistenceSessionFactory)this.persistenceSessionFactory, this.servicesList);
        this.persistenceSession.setSpecificationLoader((SpecificationLoader)this.reflector);
        sessionFactory.init();
        this.context = NakedObjectsContextStatic.createRelaxedInstance((NakedObjectSessionFactory)sessionFactory);
        NakedObjectsContext.openSession((AuthenticationSession)new TestProxySession());
    }

    public void shutdown() {
        NakedObjectsContext.closeAllSessions();
    }

    public void resetLoader() {
        this.persistenceSession.testReset();
    }

    public NakedObject createPersistentTestObject() {
        TestPojo pojo = new TestPojo();
        return this.createPersistentTestObject(pojo);
    }

    public NakedObject createPersistentTestObject(Object domainObject) {
        NakedObject adapter = this.createTransientTestObject(domainObject);
        this.getAdapterManagerPersist().remapAsPersistent(adapter);
        adapter.setOptimisticLock((Version)new TestProxyVersion(1));
        return adapter;
    }

    public void makePersistent(TestProxyNakedObject adapter) {
        Oid oid = adapter.getOid();
        this.getOidGenerator().convertTransientToPersistentOid(oid);
        adapter.setupOid(oid);
        this.persistenceSession.makePersistent((NakedObject)adapter);
    }

    public NakedObject createTransientTestObject() {
        TestPojo pojo = new TestPojo();
        return this.createTransientTestObject(pojo);
    }

    public NakedObject createTransientTestObject(Object domainObject) {
        TestProxyOid oid = new TestProxyOid(this.nextId++, false);
        NakedObject adapterFor = this.getAdapterManagerTestSupport().testCreateTransient(domainObject, (Oid)oid);
        Assert.assertEquals((String)"", (Object)ResolveState.TRANSIENT, (Object)adapterFor.getResolveState());
        return adapterFor;
    }

    public TestProxySpecification getSpecification(Class<?> type) {
        return (TestProxySpecification)this.reflector.loadSpecification(type);
    }

    public void setPersistenceSession(PersistenceSession persistor) {
        this.persistenceSession = persistor;
        if (this.context != null) {
            NakedObjectSessionDefault current = (NakedObjectSessionDefault)this.context.getSessionInstance();
            current.testSetObjectPersistor(persistor);
        }
    }

    public TestProxyNakedCollection createPersistentTestCollection() {
        TestProxyNakedCollection collection = new TestProxyNakedCollection(new Vector());
        TestProxySpecification specification = this.getSpecification(Vector.class);
        TestProxySpecification elementSpecification = this.getSpecification(Object.class);
        specification.addFacet((Facet)new TestProxyCollectionFacet());
        specification.addFacet((Facet)new TypeOfFacetDefaultToObject((FacetHolder)elementSpecification, (SpecificationLoader)this.reflector){});
        collection.setupSpecification((NakedObjectSpecification)specification);
        return collection;
    }

    public TestProxySpecification getSpecification(NakedObject object) {
        return (TestProxySpecification)object.getSpecification();
    }

    public void addSpecification(NakedObjectSpecification specification) {
        this.reflector.addSpecification(specification);
    }

    public void addConfiguration(String name, String value) {
        this.configuration.add(name, value);
    }

    public UpdateNotifier getUpdateNotifer() {
        return this.updateNotifier;
    }

    public NakedObjectReflector getReflector() {
        return this.reflector;
    }

    public PersistenceSession getPersistenceSession() {
        return this.persistenceSession;
    }

    public TestProxyConfiguration getConfiguration() {
        return this.configuration;
    }

    public AdapterFactory getAdapterFactory() {
        return this.persistenceSession.getAdapterFactory();
    }

    public AdapterManager getAdapterManager() {
        return this.persistenceSession.getAdapterManager();
    }

    public AdapterManagerTestSupport getAdapterManagerTestSupport() {
        return (AdapterManagerTestSupport)this.persistenceSession.getAdapterManager();
    }

    public AdapterManagerPersist getAdapterManagerPersist() {
        return (AdapterManagerPersist)this.persistenceSession.getAdapterManager();
    }

    private NakedObjectTransactionManager getTransactionManager() {
        return this.persistenceSession.getTransactionManager();
    }

    private OidGenerator getOidGenerator() {
        return this.persistenceSession.getOidGenerator();
    }
}

