/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.testsystem.tests;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.runtime.testsystem.ProxyJunit3TestCase;
import org.nakedobjects.runtime.testsystem.TestPojo;
import org.nakedobjects.runtime.testsystem.TestProxyOid;
import org.nakedobjects.runtime.testsystem.TestProxyVersion;

public class CreatePersistentObjectsTest
extends ProxyJunit3TestCase {
    private NakedObject adapter;
    private TestPojo pojo;
    private TestProxyOid oid;

    protected void setUp() throws Exception {
        super.setUp();
        this.pojo = new TestPojo();
        this.adapter = this.system.createPersistentTestObject(this.pojo);
        this.oid = (TestProxyOid)this.adapter.getOid();
    }

    public void testStateOfCreatedAdapted() {
        CreatePersistentObjectsTest.assertNotNull((Object)this.adapter);
        CreatePersistentObjectsTest.assertEquals((Object)this.pojo, (Object)this.adapter.getObject());
    }

    public void testResolveState() throws Exception {
        CreatePersistentObjectsTest.assertEquals((Object)ResolveState.RESOLVED, (Object)this.adapter.getResolveState());
    }

    public void testGivenVersion() throws Exception {
        CreatePersistentObjectsTest.assertEquals((Object)new TestProxyVersion(1), (Object)this.adapter.getVersion());
    }

    public void testSpecification() {
        CreatePersistentObjectsTest.assertNotNull((Object)this.adapter.getSpecification());
        CreatePersistentObjectsTest.assertNotNull((String)TestPojo.class.getName(), (Object)this.adapter.getSpecification().getFullName());
    }

    public void test2ndPersistentCreationHasDifferentOid() {
        TestPojo pojo = new TestPojo();
        NakedObject adapter2 = this.system.createPersistentTestObject(pojo);
        CreatePersistentObjectsTest.assertNotNull((Object)adapter2);
        CreatePersistentObjectsTest.assertEquals((Object)new TestProxyOid(90001, true), (Object)adapter2.getOid());
    }

    public void testOidChanged() throws Exception {
        CreatePersistentObjectsTest.assertEquals((Object)new TestProxyOid(90000, true), (Object)this.oid);
    }

    public void testOidHasPrevious() throws Exception {
        CreatePersistentObjectsTest.assertNotNull((Object)this.oid.getPrevious());
        CreatePersistentObjectsTest.assertEquals((Object)new TestProxyOid(1, false), (Object)this.oid.getPrevious());
    }

    public void testPreviousOidIsRemovedFromMap() throws Exception {
        NakedObject a = CreatePersistentObjectsTest.getAdapterManager().getAdapterFor(this.oid.getPrevious());
        CreatePersistentObjectsTest.assertNull((Object)a);
    }

    public void testIsAddedToMap() throws Exception {
        NakedObject a = CreatePersistentObjectsTest.getAdapterManager().getAdapterFor((Oid)this.oid);
        CreatePersistentObjectsTest.assertEquals((Object)this.adapter, (Object)a);
    }

    public void testAddedToPersistor() throws Exception {
        NakedObject a = CreatePersistentObjectsTest.getPersistenceSession().loadObject((Oid)this.oid, this.adapter.getSpecification());
        CreatePersistentObjectsTest.assertEquals((Object)this.adapter, (Object)a);
    }
}

