/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.authorization;

import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.facetdecorator.FacetDecoratorAbstract;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.disable.DisableForSessionFacet;
import org.nakedobjects.metamodel.facets.disable.DisableForSessionFacetAbstract;
import org.nakedobjects.metamodel.facets.hide.HideForSessionFacet;
import org.nakedobjects.metamodel.facets.hide.HideForSessionFacetAbstract;
import org.nakedobjects.metamodel.spec.identifier.Identified;
import org.nakedobjects.runtime.authorization.AuthorizationFacetDecorator;
import org.nakedobjects.runtime.authorization.AuthorizationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthorizationFacetDecoratorAbstract
extends FacetDecoratorAbstract
implements AuthorizationFacetDecorator {
    private final AuthorizationManager authorisationManager;

    public AuthorizationFacetDecoratorAbstract(AuthorizationManager authorisationManager) {
        this.authorisationManager = authorisationManager;
    }

    public Facet decorate(Facet facet, FacetHolder holder) {
        if (!(holder instanceof Identified)) {
            return null;
        }
        Identified identified = (Identified)holder;
        final Identifier identifier = identified.getIdentifier();
        Class facetType = facet.facetType();
        FacetHolder facetHolder = facet.getFacetHolder();
        if (facetType == HideForSessionFacet.class) {
            return new HideForSessionFacetAbstract(facetHolder){

                public String hiddenReason(AuthenticationSession session) {
                    return AuthorizationFacetDecoratorAbstract.this.authorisationManager.isVisible(session, identifier) ? null : "Not authorized to view";
                }
            };
        }
        if (facetType == DisableForSessionFacet.class) {
            return new DisableForSessionFacetAbstract(facetHolder){

                public String disabledReason(AuthenticationSession session) {
                    return AuthorizationFacetDecoratorAbstract.this.authorisationManager.isUsable(session, identifier) ? null : "Not authorized to edit";
                }
            };
        }
        return facet;
    }

    public Class<? extends Facet>[] forFacetTypes() {
        return new Class[]{HideForSessionFacet.class, DisableForSessionFacet.class};
    }
}

