/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.authorization.standard.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.spec.identifier.IdentifierFactory;
import org.nakedobjects.runtime.authorization.standard.Authorizor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAuthorizor
implements Authorizor {
    private static final String AUTH_BLACK_FILE_DEFAULT = "";
    private static final Logger LOG = Logger.getLogger(FileAuthorizor.class);
    private static final String AUTH_WHITE_FILE_KEY = "nakedobjects.security.whitelist.file";
    private static final String AUTH_WHITE_FILE_DEFAULT = "config/allow";
    private static final String AUTH_BLACK_FILE = "nakedobjects.security.blacklist.file";
    private static final String AUTH_LEARN = "security.learn";
    private static final String NONE = "";
    private static final String RO = "-ro";
    private static final String RW = "-rw";
    private final Map<String, List<String>> whiteListMap = new HashMap<String, List<String>>();
    private final Map<String, List<String>> blackListMap = new HashMap<String, List<String>>();
    private final boolean learn;
    private final File whiteListFile;
    private File blackListFile;
    private NakedObjectConfiguration configuration;

    public FileAuthorizor(NakedObjectConfiguration configuration) {
        this.configuration = configuration;
        this.learn = this.getConfiguration().getBoolean("nakedobjects.security.learn", false);
        String whiteListFileName = this.getConfiguration().getString(AUTH_WHITE_FILE_KEY, AUTH_WHITE_FILE_DEFAULT);
        Assert.assertTrue((whiteListFileName.length() > 0 ? 1 : 0) != 0);
        this.whiteListFile = new File(whiteListFileName);
        if (!this.learn && !this.whiteListFile.canRead()) {
            throw new NakedObjectException("Cannot read white list security file: " + whiteListFileName);
        }
        String blackListFileName = this.getConfiguration().getString(AUTH_BLACK_FILE, "");
        if (blackListFileName.length() > 0) {
            this.blackListFile = new File(blackListFileName);
            if (!this.blackListFile.canRead()) {
                throw new NakedObjectException("Cannot read black list security file: " + blackListFileName);
            }
        }
    }

    private void tokenizeLine(Map<String, List<String>> map, String line) {
        StringTokenizer tokens = new StringTokenizer(line, ":", false);
        Assert.assertTrue((tokens.countTokens() == 2 ? 1 : 0) != 0);
        String token1 = tokens.nextToken();
        String token2 = tokens.nextToken();
        Identifier identifier = this.memberFromString(token1.trim());
        List<String> roles = this.tokenizeRoles(token2);
        String identityString = identifier.toIdentityString(2);
        map.put(identityString, roles);
    }

    public void buildMap(Map<String, List<String>> map, File file) {
        try {
            String line;
            LOG.info((Object)("loading authorisation details from " + file.getAbsolutePath()));
            FileReader fileReader = new FileReader(file);
            BufferedReader buffReader = new BufferedReader(fileReader);
            while ((line = buffReader.readLine()) != null) {
                this.tokenizeLine(map, line);
            }
            fileReader.close();
            buffReader.close();
        }
        catch (Exception e) {
            throw new NakedObjectException((Throwable)e);
        }
    }

    public void init() {
        if (this.learn) {
            return;
        }
        this.buildMap(this.whiteListMap, this.whiteListFile);
        if (this.blackListFile != null) {
            this.buildMap(this.blackListMap, this.blackListFile);
        }
    }

    private List<String> tokenizeRoles(String allRoles) {
        ArrayList<String> roles = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(allRoles, "|", false);
        while (tokens.hasMoreTokens()) {
            String nextToken = tokens.nextToken();
            String trimmedNextToken = nextToken.trim();
            roles.add(trimmedNextToken);
        }
        return roles;
    }

    private Identifier memberFromString(String identifier) {
        return IdentifierFactory.fromIdentityString((String)identifier);
    }

    private boolean isQualifiedMatch(Map<String, List<String>> map, String role, String key, String[] qualifiers) {
        if (map.containsKey(key)) {
            List<String> roles = map.get(key);
            for (int i = 0; i < qualifiers.length; ++i) {
                String qualifiedRole = role + qualifiers[i];
                if (!roles.contains(qualifiedRole)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isListed(Map<String, List<String>> map, String role, Identifier member, String[] qualifiers) {
        if (map.isEmpty()) {
            return false;
        }
        for (int depth = 0; depth <= 2; ++depth) {
            if (!this.isQualifiedMatch(map, role, member.toIdentityString(depth), qualifiers)) continue;
            return true;
        }
        return false;
    }

    private boolean isWhiteListed(String role, Identifier member, String[] qualifiers) {
        return this.isListed(this.whiteListMap, role, member, qualifiers);
    }

    private boolean isBlackListed(String role, Identifier member, String[] qualifiers) {
        return this.isListed(this.blackListMap, role, member, qualifiers);
    }

    private boolean isAuthorised(String role, Identifier member, String[] qualifiers) {
        if (this.learn) {
            return this.learn(role, member);
        }
        return this.isWhiteListed(role, member, qualifiers) && !this.isBlackListed(role, member, qualifiers);
    }

    public void shutdown() {
        if (this.learn) {
            this.writeMap();
        }
    }

    private void writeMap() {
        try {
            LOG.info((Object)("writing authorisation details to " + this.whiteListFile.getAbsolutePath()));
            FileWriter fileWriter = new FileWriter(this.whiteListFile);
            BufferedWriter buffWriter = new BufferedWriter(fileWriter);
            Set<Map.Entry<String, List<String>>> entrySet = this.whiteListMap.entrySet();
            for (int i = 0; i < entrySet.size(); ++i) {
                Map.Entry entry = (Map.Entry)entrySet.toArray()[i];
                StringBuffer buff = new StringBuffer();
                buff.append((String)entry.getKey()).append(":");
                List roles = (List)entry.getValue();
                for (int j = 0; j < roles.size(); ++j) {
                    buff.append((String)roles.get(j));
                    if (j >= roles.size() - 1) continue;
                    buff.append("|");
                }
                buffWriter.write(buff.toString());
                buffWriter.newLine();
            }
            buffWriter.flush();
            buffWriter.close();
        }
        catch (IOException e) {
            throw new NakedObjectException((Throwable)e);
        }
    }

    private boolean learn(String role, Identifier member) {
        String identityString = member.toIdentityString(2);
        if (this.whiteListMap.containsKey(identityString)) {
            List<String> roles = this.whiteListMap.get(identityString);
            if (!roles.contains(role)) {
                roles.add(role);
            }
        } else {
            this.whiteListMap.put(identityString, Arrays.asList(role));
        }
        return true;
    }

    @Override
    public boolean isUsable(String role, Identifier member) {
        return this.isAuthorised(role, member, new String[]{"", RW});
    }

    @Override
    public boolean isVisible(String role, Identifier member) {
        return this.isAuthorised(role, member, new String[]{"", RO, RW});
    }

    public NakedObjectConfiguration getConfiguration() {
        return this.configuration;
    }
}

