/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.boot;

import org.nakedobjects.metamodel.config.loader.ConfigurationLoader;
import org.nakedobjects.metamodel.config.loader.ConfigurationLoaderDefault;
import org.nakedobjects.metamodel.config.loader.NotFoundPolicy;
import org.nakedobjects.runtime.boot.BootSystemParameter;
import org.nakedobjects.runtime.boot.systemfactory.NakedObjectSystemFactory;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.system.NakedObjectsSystem;

public abstract class NakedObjectsBootstrapperAbstract {
    private final NakedObjectSystemFactory systemFactory;

    public NakedObjectsBootstrapperAbstract(NakedObjectSystemFactory systemFactory) {
        this.systemFactory = systemFactory;
    }

    public NakedObjectSystemFactory getSystemFactory() {
        return this.systemFactory;
    }

    protected void bootSystem(BootSystemParameter boot) {
        ConfigurationLoaderDefault configurationLoader = this.createConfigurationLoader(boot);
        NakedObjectsSystem system = this.systemFactory.createSystem((ConfigurationLoader)configurationLoader, boot.loggingLevel, boot.deploymentType, boot.splash);
        system.init();
        this.startClientOrServer(boot.user, boot.password, system);
    }

    private ConfigurationLoaderDefault createConfigurationLoader(BootSystemParameter boot) {
        ConfigurationLoaderDefault configurationLoader = new ConfigurationLoaderDefault();
        this.addConfigurationFiles(configurationLoader, boot.deploymentType, boot.config);
        this.addConfigurationProperties(configurationLoader, boot.additionalProperties);
        configurationLoader.add("nakedobjects.reflector", boot.reflector);
        configurationLoader.add("nakedobjects.persistor", boot.persistenceMechanism);
        configurationLoader.add("nakedobjects.connector", boot.connection);
        configurationLoader.add("nakedobjects.viewer", boot.viewer);
        configurationLoader.add("nakedobjects.fixture", boot.fixture);
        return configurationLoader;
    }

    private void startClientOrServer(String user, String password, NakedObjectsSystem system) {
        system.startClient(user, password);
        system.startServer();
    }

    private void addConfigurationFiles(ConfigurationLoaderDefault loader, DeploymentType deploymentType, String config) {
        if (config != null) {
            loader.addConfigurationFile(config, NotFoundPolicy.FAIL_FAST);
        }
        String type = deploymentType.name().toLowerCase();
        loader.addConfigurationFile(type + ".properties", NotFoundPolicy.CONTINUE);
    }

    private void addConfigurationProperties(ConfigurationLoaderDefault loader, String[] additionalProperties) {
        if (additionalProperties != null) {
            for (int i = 0; i < additionalProperties.length; i += 2) {
                loader.add(additionalProperties[i], additionalProperties[i + 1]);
            }
        }
    }
}

