/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.client;

import org.nakedobjects.applib.fixtures.LogonFixture;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.standard.ExplorationSession;
import org.nakedobjects.runtime.authentication.standard.MultiUserExplorationSession;
import org.nakedobjects.runtime.authentication.standard.SimpleSession;
import org.nakedobjects.runtime.client.NakedObjectClient;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.system.DeploymentType;

public abstract class NakedObjectClientAbstract
implements NakedObjectClient {
    private static final String NAKEDOBJECTS_USERS = "nakedobjects.exploration.users";
    protected AuthenticationManager authenticationManager;
    protected String title;
    private DeploymentType deploymentType;
    private LogonFixture logonFixture;
    private AuthenticationRequest authenticationRequestViaArgs;

    public abstract void run();

    public void shutdown() {
        System.exit(0);
    }

    protected boolean login() {
        AuthenticationSession session = null;
        if ((this.deploymentType.isExploring() || this.deploymentType.isPrototyping()) && this.logonFixture != null) {
            session = new SimpleSession(this.logonFixture.getUsername(), this.logonFixture.getRoles());
        }
        if (session == null && this.deploymentType.isExploring()) {
            String users = NakedObjectsContext.getConfiguration().getString(NAKEDOBJECTS_USERS);
            session = users == null ? new ExplorationSession() : new MultiUserExplorationSession(users);
        }
        while (session == null) {
            AuthenticationRequest request = this.authenticationRequestViaArgs;
            if (request == null) {
                request = this.promptForAuthenticationDetails();
            }
            if (request == null) {
                return false;
            }
            session = this.authenticationManager.authenticate(request);
            this.authenticationRequestViaArgs = null;
        }
        NakedObjectsContext.openSession(session);
        return true;
    }

    protected abstract AuthenticationRequest promptForAuthenticationDetails();

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDeploymentType(DeploymentType deploymentType) {
        this.deploymentType = deploymentType;
    }

    public void setLogonFixture(LogonFixture logonFixture) {
        this.logonFixture = logonFixture;
    }

    public void setAuthenticationRequestViaArgs(AuthenticationRequest authenticationRequest) {
        this.authenticationRequestViaArgs = authenticationRequest;
    }

    protected boolean isInExplorationMode() {
        return this.deploymentType.isExploring();
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }
}

