/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.memento;

import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.runtime.memento.Data;

class CollectionData
extends Data {
    private static final long serialVersionUID = 1L;
    final Data[] elements;

    public CollectionData(Oid oid, ResolveState resolveState, String className, Data[] elements) {
        super(oid, resolveState.name(), className);
        this.elements = elements;
    }

    public CollectionData(ByteDecoder decoder) {
        super(decoder);
        int no = decoder.getInt();
        this.elements = new Data[no];
        for (int i = 0; i < no; ++i) {
            this.elements[i] = (Data)decoder.getObject();
        }
    }

    public void debug(DebugString debug) {
        super.debug(debug);
        for (int i = 0; i < this.elements.length; ++i) {
            debug.appendln("" + i + 1, (Object)this.elements[i]);
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer("(");
        for (int i = 0; i < this.elements.length; ++i) {
            str.append(i > 0 ? "," : "");
            str.append(this.elements[i]);
        }
        str.append(")");
        return str.toString();
    }

    public void encode(ByteEncoder encoder) {
        super.encode(encoder);
        int no = this.elements.length;
        encoder.add(no);
        for (int i = 0; i < no; ++i) {
            this.elements[i].encode(encoder);
        }
    }
}

