/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.objectstore.inmemory.internal.commands;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.runtime.objectstore.inmemory.internal.ObjectStoreInstances;
import org.nakedobjects.runtime.objectstore.inmemory.internal.ObjectStorePersistedObjects;
import org.nakedobjects.runtime.transaction.ObjectPersistenceException;
import org.nakedobjects.runtime.transaction.PersistenceCommandAbstract;

public abstract class AbstractInMemoryPersistenceCommand
extends PersistenceCommandAbstract {
    private static final Logger LOG = Logger.getLogger(AbstractInMemoryPersistenceCommand.class);
    private final ObjectStorePersistedObjects persistedObjects;

    public AbstractInMemoryPersistenceCommand(NakedObject adapter, ObjectStorePersistedObjects persistedObjects) {
        super(adapter);
        this.persistedObjects = persistedObjects;
    }

    protected void save(NakedObject adapter) throws ObjectPersistenceException {
        NakedObjectSpecification specification = adapter.getSpecification();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("   saving object " + adapter + " as instance of " + specification.getShortName()));
        }
        ObjectStoreInstances ins = this.instancesFor(specification);
        ins.save(adapter);
    }

    protected void destroy(NakedObject adapter) {
        NakedObjectSpecification specification = adapter.getSpecification();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("   destroy object " + adapter + " as instance of " + specification.getShortName()));
        }
        ObjectStoreInstances ins = this.instancesFor(specification);
        ins.remove(adapter.getOid());
    }

    private ObjectStoreInstances instancesFor(NakedObjectSpecification spec) {
        return this.persistedObjects.instancesFor(spec);
    }
}

