/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.adapterfactory.pojo;

import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.adapter.Instance;
import org.nakedobjects.metamodel.adapter.InstanceAbstract;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.AggregatedOid;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.Specification;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.ConcurrencyException;
import org.nakedobjects.runtime.persistence.PersistenceSession;

public class PojoAdapter
extends InstanceAbstract
implements NakedObject {
    private static final Logger LOG = Logger.getLogger(PojoAdapter.class);
    private static final int INCOMPLETE_COLLECTION = -1;
    private Object pojo;
    private transient ResolveState resolveState;
    private Oid oid;
    private Version version;
    private String defaultTitle;
    private TypeOfFacet typeOfFacet;

    public PojoAdapter(Object pojo, Oid oid) {
        if (pojo instanceof NakedObject) {
            throw new NakedObjectException("Adapter can't be used to adapt an adapter: " + pojo);
        }
        this.pojo = pojo;
        this.oid = oid;
        this.resolveState = ResolveState.NEW;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("finalizing pojo, oid: " + this.getOid()));
        }
    }

    protected NakedObjectSpecification loadSpecification() {
        NakedObjectSpecification specification = this.getReflector().loadSpecification(this.getObject().getClass());
        this.defaultTitle = "A" + (" " + specification.getSingularName()).toLowerCase();
        return specification;
    }

    public final NakedObjectSpecification getSpecification() {
        NakedObjectSpecification specification = (NakedObjectSpecification)super.getSpecification();
        return specification;
    }

    public Object getObject() {
        return this.pojo;
    }

    public void replacePojo(Object pojo) {
        this.pojo = pojo;
    }

    public ResolveState getResolveState() {
        return this.resolveState;
    }

    public void changeState(ResolveState newState) {
        boolean validToChangeTo = this.resolveState.isValidToChangeTo(newState);
        Assert.assertTrue((String)("oid= " + this.getOid() + "; can't change from " + this.resolveState.name() + " to " + newState.name()), (boolean)validToChangeTo);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("oid= " + this.getOid() + "; changing state to " + newState.name()));
        }
        this.resolveState = newState;
    }

    private boolean elementsLoaded() {
        return this.isTransient() || this.getResolveState().isResolved();
    }

    public boolean isPersistent() {
        return this.getResolveState().isPersistent();
    }

    public boolean isTransient() {
        return this.getResolveState().isTransient();
    }

    public Oid getOid() {
        return this.oid;
    }

    protected void setOid(Oid oid) {
        Ensure.ensureThatArg((Object)oid, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.oid = oid;
    }

    public boolean isAggregated() {
        return this.getOid() instanceof AggregatedOid;
    }

    public Version getVersion() {
        return this.version;
    }

    public void checkLock(Version version) {
        if (this.version != null && this.version.different(version)) {
            LOG.info((Object)("concurrency conflict on " + (Object)((Object)this) + " (" + version + ")"));
            throw new ConcurrencyException(this, version);
        }
    }

    public void setOptimisticLock(Version version) {
        if (this.shouldSetVersion(version)) {
            this.version = version;
        }
    }

    private boolean shouldSetVersion(Version version) {
        return this.version == null || version == null || version.different(this.version);
    }

    public String titleString() {
        if (this.getSpecification().isCollection()) {
            CollectionFacet facet = (CollectionFacet)this.getSpecification().getFacet(CollectionFacet.class);
            return this.collectionTitleString(facet);
        }
        return this.objectTitleString();
    }

    private String objectTitleString() {
        ResolveState resolveState = this.getResolveState();
        if (resolveState.isNew()) {
            return "";
        }
        NakedObjectSpecification specification = this.getSpecification();
        String title = specification.getTitle((NakedObject)this);
        if (title == null && resolveState.isGhost()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("attempting to use unresolved object; resolving it immediately: oid=" + this.getOid()));
            }
            this.getObjectPersistor().resolveImmediately(this);
        }
        if (title == null) {
            title = this.getDefaultTitle();
        }
        return title;
    }

    private String collectionTitleString(CollectionFacet facet) {
        NakedObjectSpecification elementSpecification;
        int size = this.elementsLoaded() ? facet.size((NakedObject)this) : -1;
        TypeOfFacet typeFacet = this.getTypeOfFacet();
        NakedObjectSpecification nakedObjectSpecification = elementSpecification = typeFacet == null ? null : typeFacet.valueSpec();
        if (elementSpecification == null || elementSpecification.getFullName().equals(Object.class.getName())) {
            switch (size) {
                case -1: {
                    return "Objects";
                }
                case 0: {
                    return "No objects";
                }
                case 1: {
                    return "1 object";
                }
            }
            return size + " objects";
        }
        switch (size) {
            case -1: {
                return elementSpecification.getPluralName();
            }
            case 0: {
                return "No " + elementSpecification.getPluralName();
            }
            case 1: {
                return "1 " + elementSpecification.getSingularName();
            }
        }
        return size + " " + elementSpecification.getPluralName();
    }

    public synchronized String toString() {
        ToString str = new ToString((Object)this);
        this.toString(str);
        str.append("pojo-toString", this.pojo.toString());
        str.appendAsHex("pojo-hash", (long)this.pojo.hashCode());
        return str.toString();
    }

    protected String getDefaultTitle() {
        return this.defaultTitle;
    }

    protected void toString(ToString str) {
        str.append(this.resolveState.code());
        Oid oid = this.getOid();
        if (oid != null) {
            str.append(":");
            str.append(oid.toString());
        } else {
            str.append(":-");
        }
        str.setAddComma();
        if (this.getSpecificationNoLoad() == null) {
            str.append("class", this.getObject().getClass().getName());
        } else {
            str.append("specification", this.getSpecification().getShortName());
        }
        str.append("version", this.version == null ? null : this.version.sequence());
    }

    public String getIconName() {
        return this.getSpecification().getIconName((NakedObject)this);
    }

    public TypeOfFacet getTypeOfFacet() {
        if (this.typeOfFacet == null) {
            return (TypeOfFacet)this.getSpecification().getFacet(TypeOfFacet.class);
        }
        return this.typeOfFacet;
    }

    public void setTypeOfFacet(TypeOfFacet typeOfFacet) {
        this.typeOfFacet = typeOfFacet;
    }

    public Instance getInstance(Specification specification) {
        throw new UnsupportedOperationException();
    }

    public void fireChangedEvent() {
    }

    private SpecificationLoader getReflector() {
        return NakedObjectsContext.getSpecificationLoader();
    }

    private PersistenceSession getObjectPersistor() {
        return NakedObjectsContext.getPersistenceSession();
    }
}

