/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.adaptermanager.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.runtime.persistence.adaptermanager.internal.PojoAdapterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoAdapterHashMap
implements PojoAdapterMap {
    private static final Logger LOG = Logger.getLogger(PojoAdapterHashMap.class);
    public static final int DEFAULT_POJO_ADAPTER_MAP_SIZE = 10;
    protected final Map<Object, NakedObject> adapterByPojoMap;

    public PojoAdapterHashMap() {
        this(10);
    }

    public PojoAdapterHashMap(int capacity) {
        this.adapterByPojoMap = new HashMap<Object, NakedObject>(capacity);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LOG.info((Object)"finalizing hash of pojos");
    }

    public void open() {
    }

    public void close() {
        LOG.debug((Object)"close");
        this.adapterByPojoMap.clear();
    }

    public void reset() {
        LOG.debug((Object)"reset");
        Iterator<Map.Entry<Object, NakedObject>> iterator = this.adapterByPojoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, NakedObject> entry = iterator.next();
            NakedObject adapter = entry.getValue();
            if (adapter.getSpecification().isService()) continue;
            iterator.remove();
        }
    }

    @Override
    public void add(Object pojo, NakedObject adapter) {
        this.adapterByPojoMap.put(this.key(pojo), adapter);
        if (adapter.getResolveState().isResolved() && LOG.isDebugEnabled()) {
            LOG.debug((Object)("add " + new ToString(pojo) + " as " + adapter));
        }
    }

    @Override
    public void remove(NakedObject object) {
        LOG.debug((Object)("remove " + object));
        this.adapterByPojoMap.remove(this.key(object.getObject()));
    }

    @Override
    public boolean containsPojo(Object pojo) {
        return this.adapterByPojoMap.containsKey(this.key(pojo));
    }

    @Override
    public NakedObject getAdapter(Object pojo) {
        return this.adapterByPojoMap.get(this.key(pojo));
    }

    @Override
    public Iterator<NakedObject> iterator() {
        return this.adapterByPojoMap.values().iterator();
    }

    private Object key(Object pojo) {
        return new IdentityHashKey(pojo);
    }

    public void debugData(DebugString debug) {
        int count = 0;
        for (Object pojo : this.adapterByPojoMap.keySet()) {
            NakedObject object = this.adapterByPojoMap.get(pojo);
            debug.append(count++ + 1, 5);
            debug.append((Object)" '");
            debug.append((Object)pojo.toString(), 50);
            debug.append((Object)"'    ");
            debug.appendln(object.toString());
        }
    }

    public String debugTitle() {
        return "POJO Adapter Hashtable";
    }

    private static class IdentityHashKey {
        private Object pojo;

        public IdentityHashKey(Object pojo) {
            this.pojo = pojo;
        }

        public int hashCode() {
            return System.identityHashCode(this.pojo);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof IdentityHashKey && ((IdentityHashKey)obj).pojo == this.pojo;
        }
    }
}

