/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.objectstore;

import java.util.List;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.factory.InstanceCreationException;
import org.nakedobjects.metamodel.commons.logging.Logger;
import org.nakedobjects.metamodel.config.ConfigurationException;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.runtime.persistence.ObjectNotFoundException;
import org.nakedobjects.runtime.persistence.UnsupportedFindException;
import org.nakedobjects.runtime.persistence.objectstore.ObjectStore;
import org.nakedobjects.runtime.persistence.objectstore.transaction.CreateObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.nakedobjects.runtime.persistence.query.PersistenceQuery;
import org.nakedobjects.runtime.transaction.ObjectPersistenceException;
import org.nakedobjects.runtime.transaction.PersistenceCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NakedObjectStoreLogger
extends Logger
implements ObjectStore {
    private final ObjectStore decorated;

    public NakedObjectStoreLogger(ObjectStore decorated, String logFileName) {
        super(logFileName, false);
        this.decorated = decorated;
    }

    public NakedObjectStoreLogger(ObjectStore decorated) {
        super(null, true);
        this.decorated = decorated;
    }

    @Override
    public CreateObjectCommand createCreateObjectCommand(NakedObject object) {
        this.log("Create object " + object);
        return this.decorated.createCreateObjectCommand(object);
    }

    @Override
    public void registerService(String name, Oid oid) {
        this.log("register service " + name + " as " + oid);
        this.decorated.registerService(name, oid);
    }

    @Override
    public DestroyObjectCommand createDestroyObjectCommand(NakedObject object) {
        this.log("Destroy object " + object);
        return this.decorated.createDestroyObjectCommand(object);
    }

    @Override
    public SaveObjectCommand createSaveObjectCommand(NakedObject object) {
        this.log("Save object " + object);
        return this.decorated.createSaveObjectCommand(object);
    }

    public void debugData(DebugString debug) {
        this.decorated.debugData(debug);
    }

    public String debugTitle() {
        return this.decorated.debugTitle();
    }

    protected Class<?> getDecoratedClass() {
        return this.decorated.getClass();
    }

    @Override
    public NakedObject[] getInstances(PersistenceQuery criteria) throws ObjectPersistenceException, UnsupportedFindException {
        this.log("Get instances matching " + criteria);
        return this.decorated.getInstances(criteria);
    }

    @Override
    public NakedObject getObject(Oid oid, NakedObjectSpecification hint) throws ObjectNotFoundException, ObjectPersistenceException {
        NakedObject object = this.decorated.getObject(oid, hint);
        this.log("Get object for " + oid + " (of type " + hint.getShortName() + ")", object.getObject());
        return object;
    }

    @Override
    public Oid getOidForService(String name) {
        Oid oid = this.decorated.getOidForService(name);
        this.log("Get OID for service " + name + ": " + oid);
        return oid;
    }

    @Override
    public boolean hasInstances(NakedObjectSpecification specification) throws ObjectPersistenceException {
        boolean hasInstances = this.decorated.hasInstances(specification);
        this.log("Has instances of " + specification.getShortName(), "" + hasInstances);
        return hasInstances;
    }

    @Override
    public boolean isFixturesInstalled() {
        boolean isInitialized = this.decorated.isFixturesInstalled();
        this.log("is initialized: " + isInitialized);
        return isInitialized;
    }

    public void open() throws ConfigurationException, InstanceCreationException, ObjectPersistenceException {
        this.log("Opening " + this.name());
        this.decorated.open();
    }

    public String name() {
        return this.decorated.name();
    }

    @Override
    public void reset() {
        this.log("Reset");
        this.decorated.reset();
    }

    @Override
    public void resolveField(NakedObject object, NakedObjectAssociation field) throws ObjectPersistenceException {
        this.log("Resolve eagerly object in field " + field + " of " + object);
        this.decorated.resolveField(object, field);
    }

    @Override
    public void resolveImmediately(NakedObject object) throws ObjectPersistenceException {
        this.log("Resolve immediately: " + object);
        this.decorated.resolveImmediately(object);
    }

    @Override
    public void execute(List<PersistenceCommand> commands) throws ObjectPersistenceException {
        this.log("Execute commands");
        int i = 0;
        for (PersistenceCommand command : commands) {
            this.log("  " + i++ + " " + command);
        }
        this.decorated.execute(commands);
    }

    public void close() throws ObjectPersistenceException {
        this.log("Closing " + this.decorated);
        this.decorated.close();
    }

    @Override
    public void startTransaction() {
        this.decorated.startTransaction();
    }

    @Override
    public void endTransaction() {
        this.decorated.endTransaction();
    }

    @Override
    public void abortTransaction() {
        this.decorated.abortTransaction();
    }
}

