/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.objectstore;

import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.facets.object.callbacks.LoadedCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.LoadingCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.RemovedCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.RemovingCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.UpdatedCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.UpdatingCallbackFacet;
import org.nakedobjects.metamodel.services.ServicesInjector;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.SpecificationFacets;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.util.CallbackUtils;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.FixturesInstalledFlag;
import org.nakedobjects.runtime.persistence.NotPersistableException;
import org.nakedobjects.runtime.persistence.PersistenceSessionAbstract;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.persistence.adapterfactory.AdapterFactory;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManagerExtended;
import org.nakedobjects.runtime.persistence.objectfactory.ObjectFactory;
import org.nakedobjects.runtime.persistence.objectstore.ObjectStorePersistence;
import org.nakedobjects.runtime.persistence.objectstore.algorithm.PersistAlgorithm;
import org.nakedobjects.runtime.persistence.objectstore.algorithm.ToPersistObjectSet;
import org.nakedobjects.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.nakedobjects.runtime.persistence.objectstore.transaction.ObjectStoreTransaction;
import org.nakedobjects.runtime.persistence.objectstore.transaction.ObjectStoreTransactionManager;
import org.nakedobjects.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGenerator;
import org.nakedobjects.runtime.persistence.query.PersistenceQuery;
import org.nakedobjects.runtime.transaction.TransactionalClosure;
import org.nakedobjects.runtime.transaction.TransactionalClosureAbstract;
import org.nakedobjects.runtime.transaction.TransactionalClosureWithReturnAbstract;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifier;

public class PersistenceSessionObjectStore
extends PersistenceSessionAbstract
implements ToPersistObjectSet {
    private static final Logger LOG = Logger.getLogger(PersistenceSessionObjectStore.class);
    private final PersistAlgorithm persistAlgorithm;
    private final ObjectStorePersistence objectStore;

    public PersistenceSessionObjectStore(PersistenceSessionFactory persistenceSessionFactory, AdapterFactory adapterFactory, ObjectFactory objectFactory, ServicesInjector servicesInjector, OidGenerator oidGenerator, AdapterManagerExtended identityMap, PersistAlgorithm persistAlgorithm, ObjectStorePersistence objectStore) {
        super(persistenceSessionFactory, adapterFactory, objectFactory, servicesInjector, oidGenerator, identityMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("creating " + this));
        }
        Ensure.ensureThatArg((Object)persistAlgorithm, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"persist algorithm required");
        Ensure.ensureThatArg((Object)objectStore, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"object store required");
        this.persistAlgorithm = persistAlgorithm;
        this.objectStore = objectStore;
    }

    protected void doOpen() {
        Ensure.ensureThatState((Object)this.objectStore, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"object store required");
        Ensure.ensureThatState((Object)this.getTransactionManager(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"transaction manager required");
        Ensure.ensureThatState((Object)this.persistAlgorithm, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"persist algorithm required");
        this.injectInto(this.objectStore);
        this.getAdapterManager().injectInto(this.objectStore);
        this.getSpecificationLoader().injectInto((Object)this.objectStore);
        this.getTransactionManager().injectInto(this.objectStore);
        this.getOidGenerator().injectInto(this.objectStore);
        this.objectStore.open();
    }

    public boolean isFixturesInstalled() {
        PersistenceSessionFactory persistenceSessionFactory = this.getPersistenceSessionFactory();
        if (persistenceSessionFactory instanceof FixturesInstalledFlag) {
            FixturesInstalledFlag fixturesInstalledFlag = (FixturesInstalledFlag)((Object)persistenceSessionFactory);
            if (fixturesInstalledFlag.isFixturesInstalled() == null) {
                fixturesInstalledFlag.setFixturesInstalled(this.objectStore.isFixturesInstalled());
            }
            return fixturesInstalledFlag.isFixturesInstalled();
        }
        return this.objectStore.isFixturesInstalled();
    }

    protected void doClose() {
        this.objectStore.close();
    }

    public void testReset() {
        this.objectStore.reset();
        this.getAdapterManager().reset();
        super.testReset();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LOG.info((Object)"finalizing object manager");
    }

    public NakedObject loadObject(final Oid oid, final NakedObjectSpecification specification) {
        Ensure.ensureThatArg((Object)oid, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg((Object)specification, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        NakedObject adapter = this.getAdapterManager().getAdapterFor(oid);
        if (adapter != null) {
            return adapter;
        }
        return this.getTransactionManager().executeWithinTransaction(new TransactionalClosureWithReturnAbstract<NakedObject>(){

            @Override
            public NakedObject execute() {
                return PersistenceSessionObjectStore.this.objectStore.getObject(oid, specification);
            }
        });
    }

    public void reload(NakedObject object) {
    }

    public void resolveField(final NakedObject objectAdapter, final NakedObjectAssociation field) {
        if (field.getSpecification().isCollectionOrIsAggregated()) {
            return;
        }
        NakedObject referenceAdapter = field.get(objectAdapter);
        if (referenceAdapter == null || referenceAdapter.getResolveState().isResolved()) {
            return;
        }
        if (!referenceAdapter.isPersistent()) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("resolve field " + objectAdapter.getSpecification().getShortName() + "." + field.getId() + ": " + referenceAdapter.getSpecification().getShortName() + " " + referenceAdapter.getResolveState().code() + " " + referenceAdapter.getOid()));
        }
        this.getTransactionManager().executeWithinTransaction(new TransactionalClosureAbstract(){

            public void execute() {
                PersistenceSessionObjectStore.this.objectStore.resolveField(objectAdapter, field);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveImmediately(final NakedObject adapter) {
        AuthenticationSession authenticationSession = NakedObjectsContext.getAuthenticationSession();
        synchronized (authenticationSession) {
            ResolveState resolveState = adapter.getResolveState();
            if (!resolveState.canChangeTo(ResolveState.RESOLVING)) {
                return;
            }
            Assert.assertFalse((String)"only resolve object that is not yet resolved", (Object)adapter, (boolean)resolveState.isResolved());
            Assert.assertTrue((String)"only resolve object that is persistent", (Object)adapter, (boolean)adapter.isPersistent());
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("resolve immediately: " + adapter.getSpecification().getShortName() + " " + resolveState.code() + " " + adapter.getOid()));
            }
            this.getTransactionManager().executeWithinTransaction(new TransactionalClosure(){

                public void execute() {
                    CallbackUtils.callCallback((NakedObject)adapter, LoadingCallbackFacet.class);
                    PersistenceSessionObjectStore.this.objectStore.resolveImmediately(adapter);
                }

                public void onSuccess() {
                    CallbackUtils.callCallback((NakedObject)adapter, LoadedCallbackFacet.class);
                }

                public void onFailure() {
                }
            });
        }
    }

    public void objectChanged(final NakedObject adapter) {
        ResolveState resolveState = adapter.getResolveState();
        if (resolveState.respondToChangesInPersistentObjects()) {
            if (this.isImmutable(adapter)) {
                return;
            }
            CallbackUtils.callCallback((NakedObject)adapter, UpdatingCallbackFacet.class);
            this.getTransactionManager().executeWithinTransaction(new TransactionalClosure(){

                public void execute() {
                    SaveObjectCommand saveObjectCommand = PersistenceSessionObjectStore.this.objectStore.createSaveObjectCommand(adapter);
                    PersistenceSessionObjectStore.this.getTransactionManager().addCommand(saveObjectCommand);
                }

                public void onSuccess() {
                    CallbackUtils.callCallback((NakedObject)adapter, UpdatedCallbackFacet.class);
                }

                public void onFailure() {
                }
            });
            this.getUpdateNotifier().addChangedObject(adapter);
        }
        if (resolveState.respondToChangesInPersistentObjects() || adapter.isTransient()) {
            adapter.fireChangedEvent();
            this.getUpdateNotifier().addChangedObject(adapter);
        }
    }

    private boolean isImmutable(NakedObject adapter) {
        NakedObjectSpecification noSpec = adapter.getSpecification();
        return SpecificationFacets.isAlwaysImmutable((NakedObjectSpecification)noSpec) || SpecificationFacets.isImmutableOncePersisted((NakedObjectSpecification)noSpec) && adapter.isPersistent();
    }

    public void makePersistent(final NakedObject adapter) {
        if (adapter.isPersistent()) {
            throw new NotPersistableException("Object already persistent: " + adapter);
        }
        if (!adapter.getSpecification().persistability().isPersistable()) {
            throw new NotPersistableException("Object is not persistable: " + adapter);
        }
        NakedObjectSpecification specification = adapter.getSpecification();
        if (specification.isService()) {
            throw new NotPersistableException("Cannot persist services: " + adapter);
        }
        this.getTransactionManager().executeWithinTransaction(new TransactionalClosureAbstract(){

            public void execute() {
                PersistenceSessionObjectStore.this.persistAlgorithm.makePersistent(adapter, PersistenceSessionObjectStore.this);
            }
        });
    }

    public void destroyObject(final NakedObject adapter) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("destroyObject " + adapter));
        }
        CallbackUtils.callCallback((NakedObject)adapter, RemovingCallbackFacet.class);
        this.getTransactionManager().executeWithinTransaction(new TransactionalClosure(){

            public void execute() {
                DestroyObjectCommand command = PersistenceSessionObjectStore.this.objectStore.createDestroyObjectCommand(adapter);
                PersistenceSessionObjectStore.this.getTransactionManager().addCommand(command);
            }

            public void onSuccess() {
                CallbackUtils.callCallback((NakedObject)adapter, RemovedCallbackFacet.class);
            }

            public void onFailure() {
            }
        });
    }

    protected NakedObject[] getInstances(final PersistenceQuery persistenceQuery) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("getInstances matching " + persistenceQuery));
        }
        return this.getTransactionManager().executeWithinTransaction(new TransactionalClosureWithReturnAbstract<NakedObject[]>(){

            @Override
            public NakedObject[] execute() {
                return PersistenceSessionObjectStore.this.objectStore.getInstances(persistenceQuery);
            }

            @Override
            public void onSuccess() {
                PersistenceSessionObjectStore.this.clearAllDirty();
            }
        });
    }

    public boolean hasInstances(final NakedObjectSpecification specification) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("hasInstances of " + specification.getShortName()));
        }
        return this.getTransactionManager().executeWithinTransaction(new TransactionalClosureWithReturnAbstract<Boolean>(){

            @Override
            public Boolean execute() {
                return PersistenceSessionObjectStore.this.objectStore.hasInstances(specification);
            }
        });
    }

    protected Oid getOidForService(String name) {
        return this.objectStore.getOidForService(name);
    }

    protected void registerService(String name, Oid oid) {
        this.objectStore.registerService(name, oid);
    }

    public ObjectStoreTransactionManager getTransactionManager() {
        return (ObjectStoreTransactionManager)super.getTransactionManager();
    }

    public void addPersistedObject(NakedObject object) {
        this.getTransactionManager().addCommand(this.objectStore.createCreateObjectCommand(object));
    }

    public void remapAsPersistent(NakedObject adapter) {
        this.getAdapterManager().remapAsPersistent(adapter);
    }

    public void debugData(DebugString debug) {
        super.debugData(debug);
        debug.appendTitle("Persistor");
        this.getTransactionManager().debugData(debug);
        debug.appendln("Persist Algorithm", (Object)this.persistAlgorithm);
        debug.appendln("Object Store", (Object)this.objectStore);
        debug.appendln();
        this.objectStore.debugData(debug);
    }

    public String debugTitle() {
        return "Object Store Persistor";
    }

    public String toString() {
        ToString toString = new ToString((Object)this);
        if (this.objectStore != null) {
            toString.append("objectStore", this.objectStore.name());
        }
        if (this.persistAlgorithm != null) {
            toString.append("persistAlgorithm", this.persistAlgorithm.name());
        }
        return toString.toString();
    }

    private UpdateNotifier getUpdateNotifier() {
        return ((ObjectStoreTransaction)this.getTransactionManager().getTransaction()).getUpdateNotifier();
    }

    public ObjectStorePersistence getObjectStore() {
        return this.objectStore;
    }

    public PersistAlgorithm getPersistAlgorithm() {
        return this.persistAlgorithm;
    }
}

