/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.persistence.oidgenerator.simple;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.adapter.oid.stringable.OidStringifier;
import org.nakedobjects.metamodel.adapter.oid.stringable.directly.OidStringifierDirect;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.commons.matchers.NofMatchers;
import org.nakedobjects.runtime.persistence.oidgenerator.OidGeneratorAbstract;
import org.nakedobjects.runtime.persistence.oidgenerator.simple.SerialOid;

public class SimpleOidGenerator
extends OidGeneratorAbstract {
    private long persistentSerialNumber;
    private long transientSerialNumber;

    public SimpleOidGenerator() {
        this(1L);
    }

    public SimpleOidGenerator(long seed) {
        this(seed, Long.MIN_VALUE + seed);
    }

    public SimpleOidGenerator(Memento memento) {
        this(memento.getPersistentSerialNumber(), memento.getTransientSerialNumber());
    }

    private SimpleOidGenerator(long persistentSerialNumber, long transientSerialNumber) {
        super((OidStringifier)new OidStringifierDirect(SerialOid.class));
        Ensure.ensureThatArg((Object)persistentSerialNumber, (Matcher)CoreMatchers.is((Matcher)NofMatchers.greaterThan((Comparable)Long.valueOf(0L))));
        this.persistentSerialNumber = persistentSerialNumber;
        this.transientSerialNumber = transientSerialNumber;
    }

    public String name() {
        return "Simple Serial OID Generator";
    }

    public synchronized SerialOid createTransientOid(Object object) {
        return SerialOid.createTransient(this.transientSerialNumber--);
    }

    public synchronized void convertTransientToPersistentOid(Oid oid) {
        if (!(oid instanceof SerialOid)) {
            throw new IllegalArgumentException("Oid is not a SerialOid");
        }
        SerialOid serialOid = (SerialOid)oid;
        serialOid.setId(this.persistentSerialNumber++);
        serialOid.makePersistent();
    }

    public Memento getMemento() {
        return new Memento(this.persistentSerialNumber, this.transientSerialNumber);
    }

    public void resetTo(Memento memento) {
        this.persistentSerialNumber = memento.getPersistentSerialNumber();
        this.transientSerialNumber = memento.getTransientSerialNumber();
    }

    public void debugData(DebugString debug) {
        debug.appendln("Persistent", this.persistentSerialNumber);
        debug.appendln("Transient", this.transientSerialNumber);
    }

    public String debugTitle() {
        return this.name();
    }

    public static class Memento {
        private long persistentSerialNumber;
        private long transientSerialNumber;

        Memento(long persistentSerialNumber, long transientSerialNumber) {
            this.persistentSerialNumber = persistentSerialNumber;
            this.transientSerialNumber = transientSerialNumber;
        }

        public long getTransientSerialNumber() {
            return this.transientSerialNumber;
        }

        public long getPersistentSerialNumber() {
            return this.persistentSerialNumber;
        }
    }
}

