/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.snapshot;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetUtil;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.NakedObjectSpecificationException;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToManyAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.runtime.snapshot.NofMetaModel;
import org.nakedobjects.runtime.snapshot.Place;
import org.nakedobjects.runtime.snapshot.XmlSchema;
import org.nakedobjects.runtime.snapshot.XsMetaModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlSnapshot {
    private static final Logger LOG = Logger.getLogger(XmlSnapshot.class);
    private final boolean addOids;
    private final NofMetaModel nofMeta;
    private final Place rootPlace;
    private final XmlSchema schema;
    private String schemaLocationFileName;
    private boolean topLevelElementWritten = false;
    private final Document xmlDocument;
    private Element xmlElement;
    private final Document xsdDocument;
    private final Element xsdElement;
    private final XsMetaModel xsMeta;

    public XmlSnapshot(NakedObject rootObject) {
        this(rootObject, false);
    }

    public XmlSnapshot(NakedObject rootObject, boolean addOids) {
        this(rootObject, new XmlSchema(), addOids);
    }

    public XmlSnapshot(NakedObject rootObject, XmlSchema schema, boolean addOids) {
        LOG.debug((Object)(".ctor(" + this.log("rootObj", rootObject) + this.andlog("schema", schema) + this.andlog("addOids", "true") + ")"));
        this.addOids = addOids;
        this.nofMeta = new NofMetaModel();
        this.xsMeta = new XsMetaModel();
        this.schema = schema;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.xmlDocument = db.newDocument();
            this.xsdDocument = db.newDocument();
            this.xsdElement = this.xsMeta.createXsSchemaElement(this.xsdDocument);
            this.rootPlace = this.appendXml(rootObject);
        }
        catch (ParserConfigurationException e) {
            LOG.error((Object)"unable to build snapshot", (Throwable)e);
            throw new NakedObjectException((Throwable)e);
        }
    }

    private String andlog(String label, NakedObject object) {
        return ", " + this.log(label, object);
    }

    private String andlog(String label, Object object) {
        return ", " + this.log(label, object);
    }

    private Place appendXml(NakedObject object) {
        LOG.debug((Object)("appendXml(" + this.log("obj", object) + "')"));
        String fullyQualifiedClassName = object.getSpecification().getFullName();
        this.schema.setUri(fullyQualifiedClassName);
        Place place = this.objectToElement(object);
        Element element = place.getXmlElement();
        Element xsElementElement = place.getXsdElement();
        LOG.debug((Object)"appendXml(NO): add as element to XML doc");
        this.getXmlDocument().appendChild(element);
        LOG.debug((Object)"appendXml(NO): add as xs:element to xs:schema of the XSD document");
        this.getXsdElement().appendChild(xsElementElement);
        LOG.debug((Object)"appendXml(NO): set target name in XSD, derived from FQCN of obj");
        this.schema.setTargetNamespace(this.getXsdDocument(), fullyQualifiedClassName);
        LOG.debug((Object)"appendXml(NO): set schema location file name to XSD, derived from FQCN of obj");
        String schemaLocationFileName = fullyQualifiedClassName + ".xsd";
        this.schema.assignSchema(this.getXmlDocument(), fullyQualifiedClassName, schemaLocationFileName);
        LOG.debug((Object)"appendXml(NO): copy into snapshot obj");
        this.setXmlElement(element);
        this.setSchemaLocationFileName(schemaLocationFileName);
        return place;
    }

    private Element appendXml(Place parentPlace, NakedObject childObject) {
        LOG.debug((Object)("appendXml(" + this.log("parentPlace", parentPlace) + this.andlog("childObj", childObject) + ")"));
        Element parentElement = parentPlace.getXmlElement();
        Element parentXsElement = parentPlace.getXsdElement();
        if (parentElement.getOwnerDocument() != this.getXmlDocument()) {
            throw new IllegalArgumentException("parent XML Element must have snapshot's XML document as its owner");
        }
        LOG.debug((Object)("appendXml(Pl, NO): invoking objectToElement() for " + this.log("childObj", childObject)));
        Place childPlace = this.objectToElement(childObject);
        Element childElement = childPlace.getXmlElement();
        Element childXsElement = childPlace.getXsdElement();
        LOG.debug((Object)"appendXml(Pl, NO): invoking mergeTree of parent with child");
        childElement = this.mergeTree(parentElement, childElement);
        LOG.debug((Object)"appendXml(Pl, NO): adding XS Element to schema if required");
        this.schema.addXsElementIfNotPresent(parentXsElement, childXsElement);
        return childElement;
    }

    private boolean appendXmlThenIncludeRemaining(Place parentPlace, NakedObject referencedObject, Vector fieldNames, String annotation) {
        LOG.debug((Object)("appendXmlThenIncludeRemaining(: " + this.log("parentPlace", parentPlace) + this.andlog("referencedObj", referencedObject) + this.andlog("fieldNames", fieldNames) + this.andlog("annotation", annotation) + ")"));
        LOG.debug((Object)"appendXmlThenIncludeRemaining(..): invoking appendXml(parentPlace, referencedObject)");
        Element referencedElement = this.appendXml(parentPlace, referencedObject);
        Place referencedPlace = new Place(referencedObject, referencedElement);
        boolean includedField = this.includeField(referencedPlace, fieldNames, annotation);
        LOG.debug((Object)("appendXmlThenIncludeRemaining(..): invoked includeField(referencedPlace, fieldNames)" + this.andlog("returned", "" + includedField)));
        return includedField;
    }

    private Vector elementsUnder(Element parentElement, String localName) {
        Vector<Element> v = new Vector<Element>();
        NodeList existingNodes = parentElement.getChildNodes();
        for (int i = 0; i < existingNodes.getLength(); ++i) {
            Node node = existingNodes.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if (!localName.equals("*") && !element.getLocalName().equals(localName)) continue;
            v.addElement(element);
        }
        return v;
    }

    public NakedObject getObject() {
        return this.rootPlace.getObject();
    }

    public XmlSchema getSchema() {
        return this.getSchema();
    }

    public String getSchemaLocationFileName() {
        return this.schemaLocationFileName;
    }

    public Document getXmlDocument() {
        return this.xmlDocument;
    }

    public Element getXmlElement() {
        return this.xmlElement;
    }

    public Document getXsdDocument() {
        return this.xsdDocument;
    }

    public Element getXsdElement() {
        return this.xsdElement;
    }

    public void include(String path) {
        this.include(path, null);
    }

    public void include(String path, String annotation) {
        Vector<String> fieldNames = new Vector<String>();
        StringTokenizer tok = new StringTokenizer(path, "/");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            LOG.debug((Object)("include(..): " + this.log("token", token)));
            fieldNames.addElement(token);
        }
        LOG.debug((Object)("include(..): " + this.log("fieldNames", fieldNames)));
        LOG.debug((Object)"include(..): invoking includeField");
        this.includeField(this.rootPlace, fieldNames, annotation);
    }

    private boolean includeField(Place place, Vector fieldNames, String annotation) {
        LOG.debug((Object)("includeField(: " + this.log("place", place) + this.andlog("fieldNames", fieldNames) + this.andlog("annotation", annotation) + ")"));
        NakedObject object = place.getObject();
        Element xmlElement = place.getXmlElement();
        Vector originalNames = fieldNames;
        Vector names = new Vector();
        Enumeration e = originalNames.elements();
        while (e.hasMoreElements()) {
            names.addElement(e.nextElement());
        }
        if (names.size() == 0) {
            return true;
        }
        String fieldName = (String)names.elementAt(0);
        names.removeElementAt(0);
        LOG.debug((Object)("includeField(Pl, Vec, Str):" + this.log("processing field", fieldName) + this.andlog("left", "" + names.size())));
        NakedObjectSpecification nos = object.getSpecification();
        NakedObjectAssociation field = null;
        try {
            field = nos.getAssociation(fieldName);
        }
        catch (NakedObjectSpecificationException ex) {
            LOG.info((Object)"includeField(Pl, Vec, Str): could not locate field, skipping");
            return false;
        }
        LOG.debug((Object)"includeField(Pl, Vec, Str): locating corresponding XML element");
        Vector xmlFieldElements = this.elementsUnder(xmlElement, field.getId());
        if (xmlFieldElements.size() != 1) {
            LOG.info((Object)("includeField(Pl, Vec, Str): could not locate " + this.log("field", field.getId()) + this.andlog("xmlFieldElements.size", "" + xmlFieldElements.size())));
            return false;
        }
        Element xmlFieldElement = (Element)xmlFieldElements.elementAt(0);
        if (names.size() == 0 && annotation != null) {
            this.nofMeta.setAnnotationAttribute(xmlFieldElement, annotation);
        }
        Place fieldPlace = new Place(object, xmlFieldElement);
        if (field instanceof OneToOneAssociation) {
            if (field.getSpecification().getAssociations().length == 0) {
                LOG.debug((Object)"includeField(Pl, Vec, Str): field is value; done");
                return false;
            }
            LOG.debug((Object)"includeField(Pl, Vec, Str): field is 1->1");
            OneToOneAssociation oneToOneAssociation = (OneToOneAssociation)field;
            NakedObject referencedObject = oneToOneAssociation.get(fieldPlace.getObject());
            if (referencedObject == null) {
                return true;
            }
            boolean appendedXml = this.appendXmlThenIncludeRemaining(fieldPlace, referencedObject, names, annotation);
            LOG.debug((Object)("includeField(Pl, Vec, Str): 1->1: invoked appendXmlThenIncludeRemaining for " + this.log("referencedObj", referencedObject) + this.andlog("returned", "" + appendedXml)));
            return appendedXml;
        }
        if (field instanceof OneToManyAssociation) {
            LOG.debug((Object)"includeField(Pl, Vec, Str): field is 1->M");
            OneToManyAssociation oneToManyAssociation = (OneToManyAssociation)field;
            NakedObject collection = oneToManyAssociation.get(fieldPlace.getObject());
            CollectionFacet facet = (CollectionFacet)collection.getSpecification().getFacet(CollectionFacet.class);
            LOG.debug((Object)("includeField(Pl, Vec, Str): 1->M: " + this.log("collection.size", "" + facet.size(collection))));
            boolean allFieldsNavigated = true;
            Enumeration elements = facet.elements(collection);
            while (elements.hasMoreElements()) {
                NakedObject referencedObject = (NakedObject)elements.nextElement();
                boolean appendedXml = this.appendXmlThenIncludeRemaining(fieldPlace, referencedObject, names, annotation);
                LOG.debug((Object)("includeField(Pl, Vec, Str): 1->M: + invoked appendXmlThenIncludeRemaining for " + this.log("referencedObj", referencedObject) + this.andlog("returned", "" + appendedXml)));
                allFieldsNavigated = allFieldsNavigated && appendedXml;
            }
            LOG.debug((Object)("includeField(Pl, Vec, Str): " + this.log("returning", "" + allFieldsNavigated)));
            return allFieldsNavigated;
        }
        return false;
    }

    private String log(String label, NakedObject object) {
        return this.log(label, object == null ? "(null)" : object.titleString() + "[" + this.oidOrHashCode(object) + "]");
    }

    private String log(String label, Object object) {
        return (label == null ? "?" : label) + "='" + (object == null ? "(null)" : object.toString()) + "'";
    }

    private Element mergeTree(Element parentElement, Element childElement) {
        LOG.debug((Object)("mergeTree(" + this.log("parent", parentElement) + this.andlog("child", childElement)));
        String childElementOid = this.nofMeta.getAttribute(childElement, "oid");
        LOG.debug((Object)("mergeTree(El,El): " + this.log("childOid", childElementOid)));
        if (childElementOid != null) {
            LOG.debug((Object)"mergeTree(El,El): check if child already there");
            Vector existingChildElements = this.elementsUnder(parentElement, childElement.getLocalName());
            Enumeration childEnum = existingChildElements.elements();
            while (childEnum.hasMoreElements()) {
                Element possibleMatchingElement = (Element)childEnum.nextElement();
                String possibleMatchOid = this.nofMeta.getAttribute(possibleMatchingElement, "oid");
                if (possibleMatchOid == null || !possibleMatchOid.equals(childElementOid)) continue;
                LOG.debug((Object)"mergeTree(El,El): child already there; merging grandchildren");
                Element existingChildElement = possibleMatchingElement;
                Vector grandchildrenElements = this.elementsUnder(childElement, "*");
                Enumeration grandchildEnum = grandchildrenElements.elements();
                while (grandchildEnum.hasMoreElements()) {
                    Element grandchildElement = (Element)grandchildEnum.nextElement();
                    childElement.removeChild(grandchildElement);
                    LOG.debug((Object)("mergeTree(El,El): merging " + this.log("grandchild", grandchildElement)));
                    this.mergeTree(existingChildElement, grandchildElement);
                }
                return existingChildElement;
            }
        }
        parentElement.appendChild(childElement);
        return childElement;
    }

    Place objectToElement(NakedObject object) {
        LOG.debug((Object)("objectToElement(" + this.log("object", object) + ")"));
        NakedObjectSpecification nos = object.getSpecification();
        LOG.debug((Object)"objectToElement(NO): create element and nof:title");
        Element element = this.schema.createElement(this.getXmlDocument(), nos.getShortName(), nos.getFullName(), nos.getSingularName(), nos.getPluralName());
        this.nofMeta.appendNofTitle(element, object.titleString());
        LOG.debug((Object)"objectToElement(NO): create XS element for NOF class");
        Element xsElement = this.schema.createXsElementForNofClass(this.getXsdDocument(), element, this.topLevelElementWritten, FacetUtil.getFacetsByType((FacetHolder)nos));
        this.topLevelElementWritten = true;
        Place place = new Place(object, element);
        this.nofMeta.setAttributesForClass(element, this.oidOrHashCode(object).toString());
        NakedObjectAssociation[] fields = nos.getAssociations();
        LOG.debug((Object)"objectToElement(NO): processing fields");
        block6: for (int i = 0; i < fields.length; ++i) {
            NakedObjectAssociation field = fields[i];
            String fieldName = field.getId();
            LOG.debug((Object)("objectToElement(NO): " + this.log("field", fieldName)));
            for (int j = 0; j < i; ++j) {
                if (!fieldName.equals(fields[i])) continue;
                LOG.debug((Object)("objectToElement(NO): " + this.log("field", fieldName) + " SKIPPED"));
                continue block6;
            }
            Element xmlFieldElement = this.getXmlDocument().createElementNS(this.schema.getUri(), this.schema.getPrefix() + ":" + fieldName);
            Element xsdFieldElement = null;
            if (field.getSpecification().isEncodeable()) {
                LOG.debug((Object)("objectToElement(NO): " + this.log("field", fieldName) + " is encodeable"));
                NakedObjectSpecification fieldNos = field.getSpecification();
                if (fieldNos != null && fieldNos.getFullName() != null && fieldNos.getFullName().endsWith("XmlValue")) continue;
                OneToOneAssociation valueAssociation = (OneToOneAssociation)field;
                Element xmlValueElement = xmlFieldElement;
                try {
                    boolean notEmpty;
                    NakedObject value = valueAssociation.get(object);
                    NakedObjectSpecification valueNos = value.getSpecification();
                    if (value == null) continue;
                    this.nofMeta.setAttributesForValue(xmlValueElement, valueNos.getShortName());
                    boolean bl = notEmpty = value.titleString().length() > 0;
                    if (notEmpty) {
                        String valueStr = value.titleString();
                        xmlValueElement.appendChild(this.getXmlDocument().createTextNode(valueStr));
                    } else {
                        this.nofMeta.setIsEmptyAttribute(xmlValueElement, true);
                    }
                }
                catch (Exception ex) {
                    LOG.warn((Object)("objectToElement(NO): " + this.log("field", fieldName) + ": getField() threw exception - skipping XML generation"));
                }
                xsdFieldElement = this.schema.createXsElementForNofValue(xsElement, xmlValueElement, FacetUtil.getFacetsByType((FacetHolder)valueAssociation));
            } else if (field instanceof OneToOneAssociation) {
                LOG.debug((Object)("objectToElement(NO): " + this.log("field", fieldName) + " is OneToOneAssociation"));
                OneToOneAssociation oneToOneAssociation = (OneToOneAssociation)field;
                String fullyQualifiedClassName = nos.getFullName();
                Element xmlReferenceElement = xmlFieldElement;
                try {
                    NakedObject referencedNakedObject = oneToOneAssociation.get(object);
                    this.nofMeta.setAttributesForReference(xmlReferenceElement, this.schema.getPrefix(), fullyQualifiedClassName);
                    if (referencedNakedObject != null) {
                        this.nofMeta.appendNofTitle(xmlReferenceElement, referencedNakedObject.titleString());
                    } else {
                        this.nofMeta.setIsEmptyAttribute(xmlReferenceElement, true);
                    }
                }
                catch (Exception ex) {
                    LOG.warn((Object)("objectToElement(NO): " + this.log("field", fieldName) + ": getAssociation() threw exception - skipping XML generation"));
                }
                xsdFieldElement = this.schema.createXsElementForNofReference(xsElement, xmlReferenceElement, oneToOneAssociation.getSpecification().getFullName(), FacetUtil.getFacetsByType((FacetHolder)oneToOneAssociation));
            } else if (field instanceof OneToManyAssociation) {
                LOG.debug((Object)("objectToElement(NO): " + this.log("field", fieldName) + " is OneToManyAssociation"));
                OneToManyAssociation oneToManyAssociation = (OneToManyAssociation)field;
                Element xmlCollectionElement = xmlFieldElement;
                try {
                    NakedObject collection = oneToManyAssociation.get(object);
                    NakedObjectSpecification referencedTypeNos = oneToManyAssociation.getSpecification();
                    String fullyQualifiedClassName = referencedTypeNos.getFullName();
                    this.nofMeta.setNofCollection(xmlCollectionElement, this.schema.getPrefix(), fullyQualifiedClassName, collection, this.addOids);
                }
                catch (Exception ex) {
                    LOG.warn((Object)("objectToElement(NO): " + this.log("field", fieldName) + ": get(obj) threw exception - skipping XML generation"));
                }
                xsdFieldElement = this.schema.createXsElementForNofCollection(xsElement, xmlCollectionElement, oneToManyAssociation.getSpecification().getFullName(), FacetUtil.getFacetsByType((FacetHolder)oneToManyAssociation));
            } else {
                LOG.info((Object)("objectToElement(NO): " + this.log("field", fieldName) + " is unknown type; ignored"));
                continue;
            }
            if (xsdFieldElement != null) {
                Place.setXsdElement(xmlFieldElement, xsdFieldElement);
            }
            LOG.debug((Object)"objectToElement(NO): invoking mergeTree for field");
            xmlFieldElement = this.mergeTree(element, xmlFieldElement);
            if (xsdFieldElement == null) continue;
            LOG.debug((Object)"objectToElement(NO): adding XS element for field to schema");
            this.schema.addFieldXsElement(xsElement, xsdFieldElement);
        }
        return place;
    }

    private String oidOrHashCode(NakedObject object) {
        Oid oid = object.getOid();
        return oid.toString();
    }

    private void setSchemaLocationFileName(String schemaLocationFileName) {
        this.schemaLocationFileName = schemaLocationFileName;
    }

    private void setXmlElement(Element xmlElement) {
        this.xmlElement = xmlElement;
    }
}

