/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.system;

import org.nakedobjects.runtime.system.DeploymentCategory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DeploymentType {
    EXPLORATION(true, false, false, DeploymentCategory.EXPLORING),
    PROTOTYPE(true, false, false, DeploymentCategory.PROTOTYPING),
    STANDALONE(true, false, false, DeploymentCategory.PRODUCTION),
    CLIENT(true, true, false, DeploymentCategory.PRODUCTION),
    SERVER_EXPLORATION(false, false, true, DeploymentCategory.EXPLORING),
    SERVER_PROTOTYPE(false, false, true, DeploymentCategory.PROTOTYPING),
    SERVER(false, false, true, DeploymentCategory.PRODUCTION),
    UTILITY(false, false, false, DeploymentCategory.EXPLORING);

    private final boolean hasViewer;
    private final boolean isClientSideOnly;
    private final boolean isServerSideOnly;
    private final DeploymentCategory category;

    private DeploymentType(boolean hasViewer, boolean isClientSideOnly, boolean isServerSideOnly, DeploymentCategory category) {
        this.hasViewer = hasViewer;
        this.isClientSideOnly = isClientSideOnly;
        this.isServerSideOnly = isServerSideOnly;
        this.category = category;
    }

    public boolean isClientSideOnly() {
        return this.isClientSideOnly;
    }

    public boolean isServerSideOnly() {
        return this.isServerSideOnly;
    }

    public boolean canSpecifyRemoting() {
        return this.isClientSideOnly() || this.isServerSideOnly();
    }

    public boolean hasViewer() {
        return this.hasViewer;
    }

    public boolean canSpecifyObjectStore() {
        return true;
    }

    public boolean isMultithreaded() {
        return this.isServerSideOnly() && this.isProduction();
    }

    public boolean isExploring() {
        return this.category == DeploymentCategory.EXPLORING;
    }

    public boolean isPrototyping() {
        return this.category == DeploymentCategory.PROTOTYPING;
    }

    public boolean isProduction() {
        return this.category == DeploymentCategory.PRODUCTION;
    }

    public boolean shouldMonitor() {
        return this.isServerSideOnly() && this.isProduction();
    }
}

