/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.system;

import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;
import org.nakedobjects.applib.fixtures.LogonFixture;
import org.nakedobjects.metamodel.commons.about.AboutNakedObjects;
import org.nakedobjects.metamodel.commons.component.NoopUtils;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.threads.ThreadRunner;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.specloader.NakedObjectReflector;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.PasswordAuthenticationRequest;
import org.nakedobjects.runtime.client.NakedObjectClient;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.context.NakedObjectsContextStatic;
import org.nakedobjects.runtime.context.NakedObjectsContextThreadLocal;
import org.nakedobjects.runtime.fixturesinstaller.FixturesInstaller;
import org.nakedobjects.runtime.imageloader.TemplateImageLoader;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.remoting.ServerListener;
import org.nakedobjects.runtime.session.NakedObjectSession;
import org.nakedobjects.runtime.session.NakedObjectSessionFactory;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.system.NakedObjectSystemException;
import org.nakedobjects.runtime.system.NakedObjectsSystem;
import org.nakedobjects.runtime.system.internal.InitialisationSession;
import org.nakedobjects.runtime.system.internal.NakedObjectsLocaleInitializer;
import org.nakedobjects.runtime.system.internal.NakedObjectsTimeZoneInitializer;
import org.nakedobjects.runtime.system.internal.SplashWindow;
import org.nakedobjects.runtime.system.internal.monitor.HttpServerMonitor;
import org.nakedobjects.runtime.system.internal.monitor.SocketServerMonitor;
import org.nakedobjects.runtime.userprofile.UserProfileStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NakedObjectsSystemAbstract
implements NakedObjectsSystem {
    public static final Logger LOG = Logger.getLogger(NakedObjectsSystemAbstract.class);
    private static final int SPLASH_DELAY_DEFAULT = 6;
    private final NakedObjectsLocaleInitializer localeInitializer;
    private final NakedObjectsTimeZoneInitializer timeZoneInitializer;
    private final DeploymentType deploymentType;
    private boolean hideSplash = false;
    private SplashWindow splashWindow;
    private FixturesInstaller fixtureInstaller;
    private NakedObjectClient client;
    private List<ServerListener> listeners;
    private boolean initialized = false;
    private NakedObjectSessionFactory sessionFactory;
    private LogonFixture logonFixture;

    public NakedObjectsSystemAbstract(DeploymentType deploymentType) {
        this(deploymentType, new NakedObjectsLocaleInitializer(), new NakedObjectsTimeZoneInitializer());
    }

    public NakedObjectsSystemAbstract(DeploymentType deploymentType, NakedObjectsLocaleInitializer localeInitializer, NakedObjectsTimeZoneInitializer timeZoneInitializer) {
        this.deploymentType = deploymentType;
        this.localeInitializer = localeInitializer;
        this.timeZoneInitializer = timeZoneInitializer;
    }

    @Override
    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public void init() {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        this.initialized = true;
        LOG.info((Object)"initialising naked objects system");
        LOG.info((Object)("working directory: " + new File(".").getAbsolutePath()));
        LOG.info((Object)("root path: " + this.getConfiguration().rootPath()));
        this.localeInitializer.initLocale(this.getConfiguration());
        this.timeZoneInitializer.initTimeZone(this.getConfiguration());
        int splashDelay = 6;
        try {
            TemplateImageLoader splashLoader = this.obtainTemplateImageLoader();
            splashLoader.init();
            this.showSplash(splashLoader);
            NakedObjectsContext.setConfiguration(this.getConfiguration());
            this.sessionFactory = this.doCreateSessionFactory(this.deploymentType);
            NakedObjectsContext.setConfiguration(this.sessionFactory.getConfiguration());
            this.initContext(this.sessionFactory);
            this.sessionFactory.init();
            NakedObjectsContext.openSession(new InitialisationSession());
            this.fixtureInstaller = this.obtainFixturesInstaller();
            if (this.fixtureInstaller != null && !NoopUtils.isNoop((Object)this.fixtureInstaller)) {
                this.fixtureInstaller.installFixtures();
                if (!this.deploymentType.isProduction()) {
                    this.logonFixture = this.fixtureInstaller.getLogonFixture();
                }
            }
            NakedObjectsContext.closeSession();
            AuthenticationManager authenticationManager = this.sessionFactory.getAuthenticationManager();
            this.client = this.obtainClient();
            if (this.client != null) {
                this.client.setAuthenticationManager(authenticationManager);
            }
            this.listeners = this.obtainServerListeners();
            this.startListening(this.listeners, authenticationManager);
        }
        catch (NakedObjectSystemException ex) {
            LOG.error((Object)"failed to initialise", (Throwable)ex);
            splashDelay = 0;
            throw new RuntimeException(ex);
        }
        finally {
            this.removeSplash(splashDelay);
        }
    }

    private void initContext(NakedObjectSessionFactory sessionFactory) {
        if (!this.getDeploymentType().isMultithreaded()) {
            if (!sessionFactory.getDeploymentType().isProduction()) {
                NakedObjectsContextStatic.createRelaxedInstance(sessionFactory);
            } else {
                NakedObjectsContextStatic.createInstance(sessionFactory);
            }
        } else {
            NakedObjectsContextThreadLocal.createInstance(sessionFactory);
        }
    }

    public void shutdown() {
        LOG.info((Object)"shutting down system");
        if (this.listeners != null) {
            for (ServerListener listener : this.listeners) {
                listener.stop();
            }
        }
        NakedObjectsContext.closeAllSessions();
    }

    protected abstract NakedObjectSessionFactory doCreateSessionFactory(DeploymentType var1) throws NakedObjectSystemException;

    @Override
    public Thread startClient(final String user, final String password) {
        final DeploymentType deploymentType = this.getDeploymentType();
        if (!deploymentType.hasViewer()) {
            return null;
        }
        Runnable target = new Runnable(){

            public void run() {
                PasswordAuthenticationRequest authentationRequest = null;
                if (user != null) {
                    authentationRequest = new PasswordAuthenticationRequest(user, password);
                }
                NakedObjectsSystemAbstract.this.runClient(deploymentType, authentationRequest);
            }
        };
        return new ThreadRunner().startThread(target, "Client");
    }

    @Override
    public void startServer() {
        if (this.getDeploymentType().shouldMonitor()) {
            Runnable serverMonitorRunnable = new Runnable(){

                public void run() {
                    SocketServerMonitor serverMonitor = new SocketServerMonitor();
                    serverMonitor.setTarget(NakedObjectsSystemAbstract.this);
                    serverMonitor.listen();
                }
            };
            new ThreadRunner().startThread(serverMonitorRunnable, "Monitor-1");
            Runnable httpServerMonitorRunnable = new Runnable(){

                public void run() {
                    HttpServerMonitor httpServerMonitor = new HttpServerMonitor();
                    httpServerMonitor.setTarget(NakedObjectsSystemAbstract.this);
                    httpServerMonitor.listen();
                }
            };
            new ThreadRunner().startThread(httpServerMonitorRunnable, "Monitor-2");
        }
    }

    public NakedObjectSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public abstract NakedObjectConfiguration getConfiguration();

    protected abstract TemplateImageLoader obtainTemplateImageLoader() throws NakedObjectSystemException;

    protected abstract NakedObjectReflector obtainReflector(DeploymentType var1) throws NakedObjectSystemException;

    protected abstract PersistenceSessionFactory obtainPersistenceSessionFactory(DeploymentType var1) throws NakedObjectSystemException;

    protected abstract FixturesInstaller obtainFixturesInstaller() throws NakedObjectSystemException;

    protected abstract AuthenticationManager obtainAuthenticationManager(DeploymentType var1) throws NakedObjectSystemException;

    protected abstract UserProfileStore obtainUserProfileStore();

    protected abstract List<Object> obtainServices();

    public NakedObjectClient getClient() {
        return this.client;
    }

    protected abstract NakedObjectClient obtainClient() throws NakedObjectSystemException;

    public void runClient(DeploymentType deploymentType, AuthenticationRequest authenticationRequest) {
        NakedObjectClient client = this.getClient();
        if (client != null) {
            try {
                client.setDeploymentType(deploymentType);
                client.setLogonFixture(this.logonFixture);
                client.setAuthenticationRequestViaArgs(authenticationRequest);
                client.run();
            }
            catch (Exception e) {
                LOG.error((Object)"client start up problem", (Throwable)e);
                this.removeSplash(0);
            }
        }
    }

    public FixturesInstaller getFixturesInstaller() {
        return this.fixtureInstaller;
    }

    protected abstract List<ServerListener> obtainServerListeners() throws NakedObjectSystemException;

    private void startListening(List<ServerListener> listeners, AuthenticationManager authenticationManager) {
        for (final ServerListener listener : listeners) {
            listener.setAuthenticationManager(authenticationManager);
            Thread thread = new Thread(){

                public void run() {
                    listener.listen();
                }
            };
            thread.start();
        }
    }

    private void showSplash(TemplateImageLoader imageLoader) {
        boolean noSplash;
        boolean bl = noSplash = this.getConfiguration().getBoolean("nakedobjects.nosplash", false) || this.hideSplash;
        if (!noSplash) {
            this.splashWindow = new SplashWindow(imageLoader);
        }
    }

    public void setHideSplash(boolean hideSplash) {
        this.hideSplash = hideSplash;
    }

    private void removeSplash(int delay) {
        if (this.splashWindow != null) {
            if (delay == 0) {
                this.splashWindow.removeImmediately();
            } else {
                this.splashWindow.toFront();
                this.splashWindow.removeAfterDelay(delay);
            }
        }
    }

    private void debug(DebugString debug, Object object) {
        if (object instanceof DebugInfo) {
            DebugInfo d = (DebugInfo)object;
            debug.appendTitle(d.debugTitle());
            d.debugData(debug);
        } else {
            debug.appendln(object.toString());
            debug.appendln("... no further debug information");
        }
    }

    public DebugInfo debugSection(String selectionName) {
        if (selectionName.equals("Configuration")) {
            return this.getConfiguration();
        }
        return null;
    }

    private void debugDisplayContext(String selector, DebugString debug) {
        NakedObjectSession d = NakedObjectsContext.getSession(selector);
        if (d != null) {
            d.debugAll(debug);
        } else {
            debug.appendln("No context: " + selector);
        }
    }

    private void debugListContexts(DebugString debug) {
        String[] contextIds = NakedObjectsContext.getInstance().allSessionIds();
        for (int i = 0; i < contextIds.length; ++i) {
            debug.appendln(contextIds[i]);
            debug.appendln("-----");
            NakedObjectSession d = NakedObjectsContext.getSession(contextIds[i]);
            d.debug(debug);
            debug.appendln();
        }
    }

    private void debugListeners(DebugString debug) {
        for (ServerListener listener : this.listeners) {
            this.debug(debug, listener);
        }
    }

    public String[] debugSectionNames() {
        String[] general = new String[]{"Overview", "Authenticator", "Configuration", "Reflector", "Listeners", "Requests", "Contexts"};
        String[] contextIds = NakedObjectsContext.getInstance().allSessionIds();
        String[] combined = new String[general.length + contextIds.length];
        System.arraycopy(general, 0, combined, 0, general.length);
        System.arraycopy(contextIds, 0, combined, general.length, contextIds.length);
        return combined;
    }

    private void debugOverview(DebugString debug) {
        try {
            debug.appendln(AboutNakedObjects.getFrameworkName());
            debug.appendln(AboutNakedObjects.getFrameworkVersion());
            if (AboutNakedObjects.getApplicationName() != null) {
                debug.appendln("application: " + AboutNakedObjects.getApplicationName());
            }
            if (AboutNakedObjects.getApplicationVersion() != null) {
                debug.appendln("version" + AboutNakedObjects.getApplicationVersion());
            }
            String user = System.getProperty("user.name");
            String system = System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") " + System.getProperty("os.version");
            String java = System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version");
            debug.appendln("user: " + user);
            debug.appendln("os: " + system);
            debug.appendln("java: " + java);
            debug.appendln("working directory: " + new File(".").getAbsolutePath());
            debug.appendTitle("System Installer");
            debug.appendln("Fixture Installer", (Object)(this.fixtureInstaller == null ? "none" : this.fixtureInstaller.getClass().getName()));
            debug.appendTitle("System Components");
            debug.appendln("Authentication manager", (Object)NakedObjectsContext.getAuthenticationManager().getClass().getName());
            debug.appendln("Configuration", (Object)this.getConfiguration().getClass().getName());
            DebugInfo[] inf = NakedObjectsContext.debugSystem();
            for (int i = 0; i < inf.length; ++i) {
                if (inf[i] == null) continue;
                inf[i].debugData(debug);
            }
        }
        catch (RuntimeException e) {
            debug.appendException((Exception)e);
        }
    }
}

