/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.system.installers;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.factory.InstanceFactory;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facetdecorator.FacetDecorator;
import org.nakedobjects.metamodel.facets.FacetFactory;
import org.nakedobjects.metamodel.specloader.FacetDecoratorInstaller;
import org.nakedobjects.metamodel.specloader.JavaReflector;
import org.nakedobjects.metamodel.specloader.NakedObjectReflectorInstaller;
import org.nakedobjects.metamodel.specloader.ReflectorConstants;
import org.nakedobjects.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.nakedobjects.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistry;
import org.nakedobjects.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistryDefault;
import org.nakedobjects.metamodel.specloader.progmodelfacets.ProgrammingModelFacets;
import org.nakedobjects.metamodel.specloader.traverser.SpecificationTraverser;
import org.nakedobjects.metamodel.specloader.validator.MetaModelValidator;
import org.nakedobjects.runtime.installers.InstallerAbstract;
import org.nakedobjects.runtime.installers.InstallerLookup;
import org.nakedobjects.runtime.installers.InstallerLookupAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaReflectorInstaller
extends InstallerAbstract
implements NakedObjectReflectorInstaller,
InstallerLookupAware {
    private static final Logger LOG = Logger.getLogger(JavaReflectorInstaller.class);
    public static final String PROPERTY_BASE = "nakedobjects.";
    private final LinkedHashSet<FacetDecoratorInstaller> decoratorInstallers = new LinkedHashSet();
    private InstallerLookup installerLookup;

    public String getName() {
        return "java";
    }

    public JavaReflector createReflector() {
        ClassSubstitutor classSubstitutor = this.createClassSubstitutor(this.getConfiguration());
        CollectionTypeRegistry collectionTypeRegistry = this.createCollectionTypeRegistry(this.getConfiguration());
        SpecificationTraverser specificationTraverser = this.createSpecificationTraverser(this.getConfiguration());
        ProgrammingModelFacets programmingModelFacets = this.createProgrammingModelFacets(this.getConfiguration());
        Set<FacetDecorator> facetDecorators = this.createFacetDecorators(this.getConfiguration());
        MetaModelValidator metaModelValidator = this.createMetaModelValidator(this.getConfiguration());
        JavaReflector reflector = this.doCreateReflector(this.getConfiguration(), classSubstitutor, collectionTypeRegistry, specificationTraverser, programmingModelFacets, facetDecorators, metaModelValidator);
        return reflector;
    }

    protected ClassSubstitutor createClassSubstitutor(NakedObjectConfiguration configuration) {
        String configuredClassName = configuration.getString("nakedobjects.reflector.class-substitutor", ReflectorConstants.CLASS_SUBSTITUTOR_CLASS_NAME_DEFAULT);
        return (ClassSubstitutor)InstanceFactory.createInstance((String)configuredClassName, ClassSubstitutor.class);
    }

    protected SpecificationTraverser createSpecificationTraverser(NakedObjectConfiguration configuration) {
        String specificationTraverserClassName = configuration.getString("nakedobjects.reflector.traverser", ReflectorConstants.SPECIFICATION_TRAVERSER_CLASS_NAME_DEFAULT);
        SpecificationTraverser specificationTraverser = (SpecificationTraverser)InstanceFactory.createInstance((String)specificationTraverserClassName, SpecificationTraverser.class);
        return specificationTraverser;
    }

    protected ProgrammingModelFacets createProgrammingModelFacets(NakedObjectConfiguration configuration) {
        ProgrammingModelFacets programmingModelFacets = this.lookupAndCreateProgrammingModelFacets(configuration);
        this.includeFacetFactories(configuration, programmingModelFacets);
        this.excludeFacetFactories(configuration, programmingModelFacets);
        return programmingModelFacets;
    }

    private ProgrammingModelFacets lookupAndCreateProgrammingModelFacets(NakedObjectConfiguration configuration) {
        String progModelFacetsClassName = configuration.getString("nakedobjects.reflector.facets", ReflectorConstants.PROGRAMMING_MODEL_FACETS_CLASS_NAME_DEFAULT);
        ProgrammingModelFacets programmingModelFacets = (ProgrammingModelFacets)InstanceFactory.createInstance((String)progModelFacetsClassName, ProgrammingModelFacets.class);
        return programmingModelFacets;
    }

    protected void includeFacetFactories(NakedObjectConfiguration configuration, ProgrammingModelFacets programmingModelFacets) {
        String[] facetFactoriesIncludeClassNames = configuration.getList("nakedobjects.reflector.facets.include");
        if (facetFactoriesIncludeClassNames != null) {
            for (String facetFactoryClassName : facetFactoriesIncludeClassNames) {
                Class facetFactory = InstanceFactory.loadClass((String)facetFactoryClassName, FacetFactory.class);
                programmingModelFacets.addFactory(facetFactory);
            }
        }
    }

    protected void excludeFacetFactories(NakedObjectConfiguration configuration, ProgrammingModelFacets programmingModelFacets) {
        String[] facetFactoriesExcludeClassNames;
        for (String facetFactoryClassName : facetFactoriesExcludeClassNames = configuration.getList("nakedobjects.reflector.facets.exclude")) {
            Class facetFactory = InstanceFactory.loadClass((String)facetFactoryClassName, FacetFactory.class);
            programmingModelFacets.removeFactory(facetFactory);
        }
    }

    protected Set<FacetDecorator> createFacetDecorators(NakedObjectConfiguration configuration) {
        this.addFacetDecoratorInstallers(configuration);
        return this.createFacetDecorators(this.decoratorInstallers);
    }

    private void addFacetDecoratorInstallers(NakedObjectConfiguration configuration) {
        String[] decoratorNames;
        for (String decoratorName : decoratorNames = configuration.getList("nakedobjects.reflector.facet-decorators")) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("adding reflector facet decorator from configuration " + decoratorName));
            }
            this.addFacetDecoratorInstaller(this.lookupFacetDecorator(decoratorName));
        }
    }

    private FacetDecoratorInstaller lookupFacetDecorator(String decoratorClassName) {
        return this.installerLookup.getInstaller(FacetDecoratorInstaller.class, decoratorClassName);
    }

    private Set<FacetDecorator> createFacetDecorators(Set<FacetDecoratorInstaller> decoratorInstallers) {
        LinkedHashSet<FacetDecorator> decorators = new LinkedHashSet<FacetDecorator>();
        if (decoratorInstallers.size() == 0 && LOG.isInfoEnabled()) {
            LOG.info((Object)"No facet decorators installers added");
        }
        for (FacetDecoratorInstaller installer : decoratorInstallers) {
            decorators.add(installer.createDecorator());
        }
        return Collections.unmodifiableSet(decorators);
    }

    protected MetaModelValidator createMetaModelValidator(NakedObjectConfiguration configuration) {
        String metaModelValidatorClassName = configuration.getString("nakedobjects.reflector.validator", ReflectorConstants.META_MODEL_VALIDATOR_CLASS_NAME_DEFAULT);
        MetaModelValidator metaModelValidator = (MetaModelValidator)InstanceFactory.createInstance((String)metaModelValidatorClassName, MetaModelValidator.class);
        return metaModelValidator;
    }

    protected final CollectionTypeRegistry createCollectionTypeRegistry(NakedObjectConfiguration configuration) {
        return new CollectionTypeRegistryDefault();
    }

    protected JavaReflector doCreateReflector(NakedObjectConfiguration configuration, ClassSubstitutor classSubstitutor, CollectionTypeRegistry collectionTypeRegistry, SpecificationTraverser specificationTraverser, ProgrammingModelFacets programmingModelFacets, Set<FacetDecorator> facetDecorators, MetaModelValidator metaModelValidator) {
        return new JavaReflector(configuration, classSubstitutor, collectionTypeRegistry, specificationTraverser, programmingModelFacets, facetDecorators, metaModelValidator);
    }

    @Override
    public void setInstallerLookup(InstallerLookup installerLookup) {
        this.installerLookup = installerLookup;
    }

    public void addFacetDecoratorInstaller(FacetDecoratorInstaller decoratorInstaller) {
        if (decoratorInstaller == null) {
            return;
        }
        this.decoratorInstallers.add(decoratorInstaller);
    }
}

