/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.system.internal.monitor;

import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import org.nakedobjects.metamodel.commons.about.AboutNakedObjects;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;

public class SystemPrinter {
    private PrintStream output;

    public SystemPrinter() {
        this(System.out);
    }

    public SystemPrinter(PrintStream output) {
        this.output = output;
    }

    protected PrintStream getOutput() {
        return this.output;
    }

    void print(String string) {
        this.output.println(string);
    }

    void printBlock(String title) {
        this.print("");
        this.print("------------------------------------------");
        this.print(title);
        this.print("------------------------------------------");
    }

    public void printDiagnostics() {
        String[] files;
        this.print("------- Naked Objects diagnostics report -------");
        this.printVersion();
        this.printBlock("System properties");
        Properties properties = System.getProperties();
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            String property = properties.getProperty(name);
            if (name.endsWith(".path") || name.endsWith(".dirs")) {
                String[] split = property.split(":");
                property = split[0];
                for (int i = 1; i < split.length; ++i) {
                    property = property + "\n\t\t" + split[i];
                }
            }
            this.print(name + "= " + property);
        }
        File file = new File("../lib");
        if (file.isDirectory()) {
            files = file.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            this.printBlock("Libs");
            for (int i = 0; i < files.length; ++i) {
                this.print(files[i]);
            }
        }
        this.printBlock("Locale information");
        this.print("Default locale: " + Locale.getDefault());
        this.print("Default timezone: " + TimeZone.getDefault());
        file = new File("config");
        if (file.isDirectory()) {
            int i;
            files = file.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return new File(dir, name).isFile();
                }
            });
            this.printBlock("Config files");
            for (i = 0; i < files.length; ++i) {
                this.print(files[i]);
            }
            for (i = 0; i < files.length; ++i) {
                this.print("");
                this.print("--------------------------------------------------------------------------------------------------------");
                this.print(files[i]);
                this.print("");
                try {
                    String line;
                    LineNumberReader fileInputStream = new LineNumberReader(new FileReader(new File(file, files[i])));
                    while ((line = fileInputStream.readLine()) != null) {
                        this.print(fileInputStream.getLineNumber() + "  " + line);
                    }
                }
                catch (Exception e) {
                    throw new NakedObjectException((Throwable)e);
                }
                this.print("");
            }
        }
    }

    public void printVersion() {
        String date = AboutNakedObjects.getFrameworkCompileDate();
        String compileDate = date == null ? "" : ", compiled on " + date;
        this.print(AboutNakedObjects.getFrameworkName() + ", " + AboutNakedObjects.getFrameworkVersion() + compileDate);
    }

    public void printErrorMessage(String message) {
        this.output.println("Error: " + message);
    }
}

