/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.transaction;

import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.runtime.session.NakedObjectSession;
import org.nakedobjects.runtime.transaction.NakedObjectTransaction;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManagerAware;
import org.nakedobjects.runtime.transaction.TransactionalClosure;
import org.nakedobjects.runtime.transaction.TransactionalClosureWithReturn;
import org.nakedobjects.runtime.transaction.messagebroker.MessageBroker;
import org.nakedobjects.runtime.transaction.messagebroker.MessageBrokerDefault;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifier;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifierDefault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NakedObjectTransactionManagerAbstract<T extends NakedObjectTransaction>
implements NakedObjectTransactionManager {
    private static final Logger LOG = Logger.getLogger(NakedObjectTransactionManagerAbstract.class);
    private NakedObjectSession session;
    private T transaction;

    public void open() {
        Ensure.ensureThatState((Object)this.session, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"session is required");
    }

    public void close() {
        if (this.getTransaction() != null) {
            try {
                this.abortTransaction();
            }
            catch (Exception e2) {
                LOG.error((Object)"failure during abort", (Throwable)e2);
            }
        }
        this.session = null;
    }

    public T getTransaction() {
        return this.transaction;
    }

    protected UpdateNotifier getUpdateNotifier() {
        return this.getTransaction().getUpdateNotifier();
    }

    protected MessageBroker getMessageBroker() {
        return this.getTransaction().getMessageBroker();
    }

    @Override
    public void executeWithinTransaction(TransactionalClosure closure) {
        boolean initiallyInTransaction = this.inTransaction();
        if (!initiallyInTransaction) {
            this.startTransaction();
        }
        try {
            closure.execute();
            closure.onSuccess();
            if (!initiallyInTransaction) {
                this.endTransaction();
            }
        }
        catch (RuntimeException ex) {
            closure.onFailure();
            if (!initiallyInTransaction) {
                this.abortTransaction();
            }
            throw ex;
        }
    }

    public <Q> Q executeWithinTransaction(TransactionalClosureWithReturn<Q> closure) {
        boolean initiallyInTransaction = this.inTransaction();
        if (!initiallyInTransaction) {
            this.startTransaction();
        }
        try {
            Q retVal = closure.execute();
            closure.onSuccess();
            if (!initiallyInTransaction) {
                this.endTransaction();
            }
            return retVal;
        }
        catch (RuntimeException ex) {
            closure.onFailure();
            if (!initiallyInTransaction) {
                this.abortTransaction();
            }
            throw ex;
        }
    }

    public boolean inTransaction() {
        return this.getTransaction() != null && !this.getTransaction().getState().isComplete();
    }

    protected final T createTransaction() {
        this.transaction = this.createTransaction(this.createMessageBroker(), this.createUpdateNotifier());
        return this.transaction;
    }

    protected abstract T createTransaction(MessageBroker var1, UpdateNotifier var2);

    protected MessageBroker createMessageBroker() {
        return new MessageBrokerDefault();
    }

    protected UpdateNotifier createUpdateNotifier() {
        return new UpdateNotifierDefault();
    }

    protected void ensureTransactionInProgress() {
        Ensure.ensureThatState((Object)(this.getTransaction() != null && !this.getTransaction().getState().isComplete() ? 1 : 0), (Matcher)CoreMatchers.is((Object)true), (String)"No transaction in progress");
    }

    protected void ensureTransactionNotInProgress() {
        Ensure.ensureThatState((Object)(this.getTransaction() != null && !this.getTransaction().getState().isComplete() ? 1 : 0), (Matcher)CoreMatchers.is((Object)false), (String)"Transaction in progress");
    }

    public void injectInto(Object candidate) {
        if (NakedObjectTransactionManagerAware.class.isAssignableFrom(candidate.getClass())) {
            NakedObjectTransactionManagerAware cast = (NakedObjectTransactionManagerAware)NakedObjectTransactionManagerAware.class.cast(candidate);
            cast.setTransactionManager(this);
        }
    }

    @Override
    public void debugData(DebugString debug) {
        debug.appendln("Transaction", this.getTransaction());
    }

    @Override
    public NakedObjectSession getSession() {
        return this.session;
    }

    public void setSession(NakedObjectSession session) {
        this.session = session;
    }
}

