/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.transaction.updatenotifier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifierAbstract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateNotifierDefault
extends UpdateNotifierAbstract
implements DebugInfo {
    private static final Logger LOG = Logger.getLogger(UpdateNotifierDefault.class);
    private final List<NakedObject> changes = new ArrayList<NakedObject>();
    private final List<NakedObject> disposals = new ArrayList<NakedObject>();

    @Override
    public synchronized void addChangedObject(NakedObject adapter) {
        ResolveState resolveState = adapter.getResolveState();
        if (!resolveState.isResolved() && !adapter.isTransient()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mark as changed " + adapter));
        }
        if (!this.changes.contains(adapter)) {
            this.changes.add(adapter);
        }
    }

    @Override
    public List<NakedObject> getChangedObjects() {
        if (this.changes.size() > 0 && LOG.isDebugEnabled()) {
            LOG.debug((Object)("dirty (changed) objects " + this.changes));
        }
        ArrayList<NakedObject> changedObjects = new ArrayList<NakedObject>();
        changedObjects.addAll(this.changes);
        this.changes.clear();
        return Collections.unmodifiableList(changedObjects);
    }

    @Override
    public void addDisposedObject(NakedObject adapter) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mark as disposed " + adapter));
        }
        if (!this.disposals.contains(adapter)) {
            this.disposals.add(adapter);
        }
    }

    @Override
    public List<NakedObject> getDisposedObjects() {
        if (this.disposals.size() > 0 && LOG.isDebugEnabled()) {
            LOG.debug((Object)("dirty (disposed) objects " + this.disposals));
        }
        ArrayList<NakedObject> disposedObjects = new ArrayList<NakedObject>();
        disposedObjects.addAll(this.disposals);
        this.disposals.clear();
        return Collections.unmodifiableList(disposedObjects);
    }

    @Override
    public void ensureEmpty() {
        if (this.changes.size() > 0) {
            throw new NakedObjectException("Update notifier still has updates");
        }
    }

    @Override
    public void clear() {
        this.changes.clear();
        this.disposals.clear();
    }

    public void debugData(DebugString debug) {
        debug.appendln("Changes");
        this.debugList(debug, this.changes);
        debug.appendln("Disposals");
        this.debugList(debug, this.disposals);
    }

    public String debugTitle() {
        return "Simple Update Notifier";
    }

    private void debugList(DebugString debug, List<NakedObject> list) {
        debug.indent();
        if (list.size() == 0) {
            debug.appendln("none");
        } else {
            for (NakedObject adapter : list) {
                debug.appendln(adapter.toString());
            }
        }
        debug.unindent();
    }

    public String toString() {
        return new ToString((Object)this).append("changes", this.changes).toString();
    }
}

