/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.userprofile;

import java.util.ArrayList;
import java.util.List;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;
import org.nakedobjects.runtime.persistence.services.ServiceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerspectiveEntry
implements DebugInfo {
    private final List<Object> objects = new ArrayList<Object>();
    private final List<Object> services = new ArrayList<Object>();
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Object> getObjects() {
        return this.objects;
    }

    public List<Object> getServices() {
        return this.services;
    }

    public String getTitle() {
        return this.name + " (" + this.services.size() + " classes)";
    }

    public void addToObjects(Object obj) {
        if (!this.objects.contains(obj)) {
            this.objects.add(obj);
        }
    }

    public Object addToServices(Class serviceType) {
        Object service = this.findService(serviceType);
        this.addToServices(service);
        return service;
    }

    private Object findService(Class serviceType) {
        for (Object service : NakedObjectsContext.getServices()) {
            if (!service.getClass().isAssignableFrom(serviceType)) continue;
            return service;
        }
        throw new NakedObjectException("No service of type " + serviceType.getName());
    }

    public void addToServices(Object service) {
        if (service != null && !this.services.contains(service)) {
            this.services.add(service);
        }
    }

    public void addGenericRepository(Class type) {
        Object service = NakedObjectsContext.getPersistenceSession().getService("repository#" + type.getName()).getObject();
        this.addToServices(service);
    }

    public void removeFromObjects(Object obj) {
        this.objects.remove(obj);
    }

    public void removeServices(Class serviceType) {
        Object service = this.findService(serviceType);
        if (!this.services.contains(service)) {
            this.services.remove(service);
        }
    }

    public void removeFromServices(Object service) {
        this.services.remove(service);
    }

    public void copy(PerspectiveEntry template) {
        this.name = template.getName();
        for (Object service : template.getServices()) {
            this.addToServices(service);
        }
        for (Object obj : template.getObjects()) {
            this.addToObjects(obj);
        }
    }

    public void save(List<NakedObject> objects) {
        objects.clear();
        for (NakedObject obj : objects) {
            this.addToObjects(obj.getObject());
        }
    }

    public void debugData(DebugString debug) {
        debug.appendln("Name", (Object)this.getName());
        debug.blankLine();
        debug.appendTitle("Services (Ids)");
        debug.indent();
        for (Object service : this.getServices()) {
            debug.appendln(ServiceUtil.id(service));
        }
        debug.unindent();
        debug.blankLine();
        debug.appendTitle("Objects");
        debug.indent();
        AdapterManager adapterManager = NakedObjectsContext.getPersistenceSession().getAdapterManager();
        for (Object obj : this.getObjects()) {
            debug.appendln(adapterManager.adapterFor(obj).toString());
        }
        debug.unindent();
    }

    public String debugTitle() {
        return "Perspective";
    }
}

