/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.userprofile;

import java.util.List;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.session.NakedObjectSession;
import org.nakedobjects.runtime.userprofile.UserProfile;
import org.nakedobjects.runtime.userprofile.UserProfileLoader;
import org.nakedobjects.runtime.userprofile.UserProfileStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserProfileLoaderDefault
implements UserProfileLoader,
DebugInfo {
    private static final String DEFAULT_PERSPECTIVE_NAME = "Naked Objects Exploration";
    private Logger LOG = Logger.getLogger(UserProfile.class);
    private final UserProfileStore store;
    private final Mode mode;
    private UserProfile userProfile;
    private List<Object> serviceList;

    public UserProfileLoaderDefault(UserProfileStore store) {
        this(store, Mode.STRICT);
    }

    public UserProfileLoaderDefault(UserProfileStore store, Mode mode) {
        this.store = store;
        this.mode = mode;
    }

    public void init() {
    }

    public void shutdown() {
    }

    @Override
    public boolean isFixturesInstalled() {
        return this.store.isFixturesInstalled();
    }

    @Override
    public void saveAsDefault(UserProfile userProfile) {
        this.store.save("_default", userProfile);
    }

    @Override
    public void saveForUser(String userName, UserProfile userProfile) {
        this.store.save(userName, userProfile);
    }

    @Override
    public void saveSession(List<NakedObject> objects) {
        this.loadOrCreateProfile();
        this.userProfile.saveObjects(objects);
        this.save(this.userProfile);
    }

    private void save(UserProfile userProfile) {
        this.saveForUser(UserProfileLoaderDefault.userName(), userProfile);
    }

    @Override
    public UserProfile getProfile(AuthenticationSession session) {
        String userName = session.getUserName();
        UserProfile profile = this.store.getUserProfile(userName);
        this.userProfile = profile != null ? profile : this.createUserProfile(userName);
        return this.userProfile;
    }

    @Override
    @Deprecated
    public UserProfile getProfile() {
        this.loadOrCreateProfile();
        return this.userProfile;
    }

    private void loadOrCreateProfile() {
        if (this.userProfile == null) {
            String userName = UserProfileLoaderDefault.userName();
            UserProfile profile = this.store.getUserProfile(userName);
            this.userProfile = profile != null ? profile : this.createUserProfile(userName);
        }
    }

    private UserProfile createUserProfile(String userName) {
        UserProfile template = this.store.getUserProfile("_default");
        if (template == null) {
            return this.createDefaultProfile(userName);
        }
        return this.createProfileFromTemplate(userName, template);
    }

    private UserProfile createDefaultProfile(String userName) {
        UserProfile profile = new UserProfile();
        profile.newPerspective(DEFAULT_PERSPECTIVE_NAME);
        List<Object> services = this.getServices();
        if (services.size() == 0 && this.mode == Mode.STRICT) {
            throw new NakedObjectException("No known services");
        }
        for (Object service : services) {
            profile.getPerspective().addToServices(service);
        }
        this.LOG.info((Object)("creating exploration UserProfile for " + userName));
        return profile;
    }

    private UserProfile createProfileFromTemplate(String userName, UserProfile template) {
        UserProfile userProfile = new UserProfile();
        userProfile.copy(template);
        this.LOG.info((Object)("creating UserProfile, from template, for " + userName));
        return userProfile;
    }

    public void debugData(DebugString debug) {
        debug.append((Object)this.store);
        debug.append((Object)this.userProfile);
    }

    public String debugTitle() {
        return "User Profile Service";
    }

    @Override
    public List<Object> getServices() {
        return this.serviceList;
    }

    @Override
    public void setServices(List<Object> serviceList) {
        this.serviceList = serviceList;
    }

    private static AuthenticationSession getAuthenticationSession() {
        return UserProfileLoaderDefault.getSession().getAuthenticationSession();
    }

    private static String userName() {
        return UserProfileLoaderDefault.getAuthenticationSession().getUserName();
    }

    private static NakedObjectSession getSession() {
        return NakedObjectsContext.getSession();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        STRICT,
        RELAXED;

    }
}

