/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.util;

import java.util.Enumeration;
import java.util.Vector;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.debug.Debug;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.SpecificationFacets;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionConstants;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionParameter;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionType;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociationFacets;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociationFilters;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.metamodel.util.SpecUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Dump {
    private Dump() {
    }

    private static void collectionGraph(NakedObject collection, int level, Vector<NakedObject> ignoreObjects, DebugString s, AuthenticationSession authenticationSession) {
        if (ignoreObjects.contains(collection)) {
            s.append((Object)"*\n");
        } else {
            ignoreObjects.addElement(collection);
            CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
            Enumeration e = facet.elements(collection);
            while (e.hasMoreElements()) {
                Dump.graphIndent(s, level);
                NakedObject element = (NakedObject)e.nextElement();
                s.append((Object)element);
                if (ignoreObjects.contains(element)) {
                    s.append((Object)"*\n");
                    continue;
                }
                s.indent();
                Dump.graph(element, level + 1, ignoreObjects, s, authenticationSession);
                s.unindent();
            }
        }
    }

    public static String graph(NakedObject object, AuthenticationSession authenticationSession) {
        DebugString s = new DebugString();
        Dump.graph(object, s, authenticationSession);
        return s.toString();
    }

    public static void graph(NakedObject object, DebugString s, AuthenticationSession authenticationSession) {
        Dump.simpleObject(object, s);
        s.appendln();
        s.append((Object)object);
        Dump.graph(object, 0, new Vector<NakedObject>(25, 10), s, authenticationSession);
    }

    private static void simpleObject(NakedObject object, DebugString s) {
        s.appendln(object.titleString());
        s.indent();
        NakedObjectSpecification objectSpec = object.getSpecification();
        if (objectSpec.isCollection()) {
            CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)object);
            Enumeration e = facet.elements(object);
            int i = 1;
            while (e.hasMoreElements()) {
                NakedObject element = (NakedObject)e.nextElement();
                s.appendln(i++ + " " + element.titleString());
            }
        } else if (object instanceof NakedObject) {
            try {
                NakedObjectAssociation[] fields = objectSpec.getAssociations();
                for (int i = 0; i < fields.length; ++i) {
                    NakedObjectAssociation field = fields[i];
                    NakedObject obj = field.get(object);
                    String name = field.getId();
                    if (obj == null) {
                        s.appendln(name, (Object)"null");
                        continue;
                    }
                    s.appendln(name, (Object)obj.titleString());
                }
            }
            catch (RuntimeException e) {
                s.appendException((Exception)e);
            }
        }
        s.unindent();
    }

    private static void graph(NakedObject object, int level, Vector<NakedObject> ignoreObjects, DebugString info, AuthenticationSession authenticationSession) {
        if (level > 3) {
            info.appendln("...");
        } else {
            info.append((Object)"\n");
            if (object.getSpecification().isCollection()) {
                Dump.collectionGraph(object, level, ignoreObjects, info, authenticationSession);
            } else if (object.getSpecification().isObject()) {
                Dump.objectGraph(object, level, ignoreObjects, info, authenticationSession);
            } else {
                info.append((Object)("??? " + object));
            }
        }
    }

    public static String graph(NakedObject object, Vector<NakedObject> excludedObjects, AuthenticationSession authenticationSession) {
        DebugString s = new DebugString();
        s.append((Object)object);
        Dump.graph(object, 0, excludedObjects, s, authenticationSession);
        return s.toString();
    }

    private static void graphIndent(DebugString s, int level) {
        for (int indent = 0; indent < level; ++indent) {
            s.append((Object)(Debug.indentString((int)4) + "|"));
        }
        s.append((Object)(Debug.indentString((int)4) + "+--"));
    }

    public static String adapter(NakedObject object) {
        DebugString s = new DebugString();
        Dump.adapter(object, s);
        return s.toString();
    }

    public static void adapter(NakedObject adapter, DebugString string) {
        try {
            string.appendln("Adapter", (Object)adapter.getClass().getName());
            string.appendln("Class", (Object)(adapter.getObject() == null ? "none" : adapter.getObject().getClass().getName()));
            string.appendAsHexln("Hash", (long)adapter.hashCode());
            string.appendln("Object", adapter.getObject());
            string.appendln("Title", (Object)adapter.titleString());
            string.appendln("Specification", (Object)adapter.getSpecification().getFullName());
            string.appendln();
            string.appendln("Icon", (Object)adapter.getIconName());
            string.appendln("OID", (Object)adapter.getOid());
            string.appendln("State", (Object)adapter.getResolveState());
            string.appendln("Version", (Object)adapter.getVersion());
        }
        catch (RuntimeException e) {
            string.appendException((Exception)e);
        }
    }

    private static void objectGraph(NakedObject object, int level, Vector<NakedObject> ignoreObjects, DebugString s, AuthenticationSession authenticationSession) {
        ignoreObjects.addElement(object);
        try {
            NakedObjectAssociation[] fields = object.getSpecification().getAssociations();
            for (int i = 0; i < fields.length; ++i) {
                NakedObjectAssociation field = fields[i];
                NakedObject obj = field.get(object);
                String name = field.getId();
                Dump.graphIndent(s, level);
                if (field.isVisible(authenticationSession, object).isVetoed()) {
                    s.append((Object)(name + ": (not visible)"));
                    s.append((Object)"\n");
                    continue;
                }
                if (obj == null) {
                    s.append((Object)(name + ": null\n"));
                    continue;
                }
                if (ignoreObjects.contains(obj)) {
                    s.append((Object)(name + ": " + obj + "*\n"));
                    continue;
                }
                s.append((Object)(name + ": " + obj));
                Dump.graph(obj, level + 1, ignoreObjects, s, authenticationSession);
            }
        }
        catch (RuntimeException e) {
            s.appendException((Exception)e);
        }
    }

    public static String specification(NakedObject object) {
        DebugString s = new DebugString();
        Dump.specification(object, s);
        return s.toString();
    }

    public static void specification(NakedObject nakedObject, DebugString debug) {
        NakedObjectSpecification specification = nakedObject.getSpecification();
        Dump.specification(specification, debug);
    }

    public static void specification(NakedObjectSpecification specification, DebugString debug) {
        try {
            debug.appendTitle(specification.getClass().getName());
            debug.appendAsHexln("Hash code", (long)specification.hashCode());
            debug.appendln("ID", (Object)specification.getIdentifier());
            debug.appendln("Full Name", (Object)specification.getFullName());
            debug.appendln("Short Name", (Object)specification.getShortName());
            debug.appendln("Singular Name", (Object)specification.getSingularName());
            debug.appendln("Plural Name", (Object)specification.getPluralName());
            debug.appendln("Description", (Object)specification.getDescription());
            debug.blankLine();
            debug.appendln("Features", (Object)Dump.featureList(specification));
            debug.appendln("Type", (Object)SpecUtils.typeNameFor((NakedObjectSpecification)specification));
            if (specification.superclass() != null) {
                debug.appendln("Superclass", (Object)specification.superclass().getFullName());
            }
            debug.appendln("Interfaces", (Object[])Dump.specificationNames(specification.interfaces()));
            debug.appendln("Subclasses", (Object[])Dump.specificationNames(specification.subclasses()));
            debug.blankLine();
            debug.appendln("Service", specification.isService());
            debug.appendln("Encodable", specification.isEncodeable());
            debug.appendln("Parseable", specification.isParseable());
            debug.appendln("Aggregated", specification.isValueOrIsAggregated());
        }
        catch (RuntimeException e) {
            debug.appendException((Exception)e);
        }
        if (specification instanceof DebugInfo) {
            ((DebugInfo)specification).debugData(debug);
        }
        debug.blankLine();
        debug.appendln("Facets");
        Class[] facetTypes = specification.getFacetTypes();
        debug.indent();
        if (facetTypes.length == 0) {
            debug.appendln("none");
        } else {
            for (int i = 0; i < facetTypes.length; ++i) {
                Class type = facetTypes[i];
                Facet facet = specification.getFacet(type);
                debug.appendln(facet.toString());
            }
        }
        debug.unindent();
        debug.blankLine();
        debug.appendln("Fields");
        debug.indent();
        Dump.specificationFields(specification, debug);
        debug.unindent();
        debug.appendln("Object Actions");
        debug.indent();
        Dump.specificationActionMethods(specification, debug);
        debug.unindent();
        debug.appendln("Related Service Actions");
        debug.indent();
        Dump.specificationServiceMethods(specification, debug);
        debug.unindent();
    }

    public static String featureList(NakedObjectSpecification specification) {
        StringBuffer str = new StringBuffer();
        if (specification.isAbstract()) {
            str.append("Abstract ");
        }
        if (SpecificationFacets.isBoundedSet((NakedObjectSpecification)specification)) {
            str.append("Bounded ");
        }
        if (SpecificationFacets.isCached((NakedObjectSpecification)specification)) {
            str.append("Cached ");
        }
        if (SpecificationFacets.isAlwaysImmutable((NakedObjectSpecification)specification)) {
            str.append("Immutable (always) ");
        }
        if (SpecificationFacets.isImmutableOncePersisted((NakedObjectSpecification)specification)) {
            str.append("Immutable (once persisted) ");
        }
        if (specification.isService()) {
            str.append("Service ");
        }
        return str.toString();
    }

    private static void specificationActionMethods(NakedObjectSpecification specification, DebugString debug) {
        try {
            NakedObjectAction[] userActions = specification.getObjectActions(new NakedObjectActionType[]{NakedObjectActionConstants.USER});
            NakedObjectAction[] explActions = specification.getObjectActions(new NakedObjectActionType[]{NakedObjectActionConstants.EXPLORATION});
            NakedObjectAction[] debActions = specification.getObjectActions(new NakedObjectActionType[]{NakedObjectActionConstants.DEBUG});
            Dump.specificationMethods(userActions, explActions, debActions, debug);
        }
        catch (RuntimeException e) {
            debug.appendException((Exception)e);
        }
    }

    private static void specificationServiceMethods(NakedObjectSpecification specification, DebugString debug) {
        try {
            NakedObjectAction[] userActions = specification.getServiceActionsFor(NakedObjectActionConstants.USER);
            NakedObjectAction[] explActions = specification.getServiceActionsFor(NakedObjectActionConstants.EXPLORATION);
            NakedObjectAction[] debActions = specification.getServiceActionsFor(NakedObjectActionConstants.DEBUG);
            Dump.specificationMethods(userActions, explActions, debActions, debug);
        }
        catch (RuntimeException e) {
            debug.appendException((Exception)e);
        }
    }

    private static void specificationFields(NakedObjectSpecification specification, DebugString debug) {
        int i;
        NakedObjectAssociation[] fields = specification.getAssociations();
        debug.appendln("All");
        debug.indent();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            debug.appendln(i2 + 1 + "." + fields[i2].getId());
        }
        debug.unindent();
        NakedObjectAssociation[] fields2 = specification.getAssociations(NakedObjectAssociationFilters.STATICALLY_VISIBLE_ASSOCIATIONS);
        debug.appendln("Static");
        debug.indent();
        for (i = 0; i < fields2.length; ++i) {
            debug.appendln(i + 1 + "." + fields2[i].getId());
        }
        debug.unindent();
        debug.appendln();
        try {
            if (fields.length == 0) {
                debug.appendln("none");
            } else {
                for (i = 0; i < fields.length; ++i) {
                    String help;
                    NakedObjectAssociation field = fields[i];
                    debug.appendln(i + 1 + "." + field.getId() + "  (" + field.getClass().getName() + ")");
                    debug.indent();
                    String description = field.getDescription();
                    if (description != null && !description.equals("")) {
                        debug.appendln("Description", (Object)description);
                    }
                    if ((help = field.getHelp()) != null && !help.equals("")) {
                        debug.appendln("Help", (Object)(help.substring(0, Math.min(30, help.length())) + (help.length() > 30 ? "..." : "")));
                    }
                    debug.appendln("ID", (Object)field.getIdentifier());
                    debug.appendln("Short ID", (Object)field.getId());
                    debug.appendln("Name", (Object)field.getName());
                    String type = field.isOneToManyAssociation() ? "Collection" : (field.isOneToOneAssociation() ? "Object" : "Unknown");
                    debug.appendln("Type", (Object)type);
                    debug.appendln("Has identity", !field.getSpecification().isCollectionOrIsAggregated());
                    debug.appendln("Spec", (Object)field.getSpecification().getFullName());
                    debug.appendln("Flags", (Object)((NakedObjectAssociationFacets.isHidden((NakedObjectAssociation)field) ? "" : "Visible ") + (NakedObjectAssociationFacets.isNotPersisted((NakedObjectAssociation)field) ? "Not Persisted" : " ") + (field.isMandatory() ? "Mandatory " : "")));
                    Class[] facets = field.getFacetTypes();
                    if (facets.length > 0) {
                        debug.appendln("Facets");
                        debug.indent();
                        boolean none = true;
                        for (int j = 0; j < facets.length; ++j) {
                            debug.appendln(field.getFacet(facets[j]).toString());
                            none = false;
                        }
                        if (none) {
                            debug.appendln("none");
                        }
                        debug.unindent();
                    }
                    debug.appendln(field.debugData());
                    debug.unindent();
                    debug.unindent();
                    debug.indent();
                }
            }
        }
        catch (RuntimeException e) {
            debug.appendException((Exception)e);
        }
    }

    private static void specificationMethods(NakedObjectAction[] userActions, NakedObjectAction[] explActions, NakedObjectAction[] debActions, DebugString debug) {
        if (userActions.length == 0 && explActions.length == 0 && debActions.length == 0) {
            debug.appendln("no actions...");
        } else {
            int i;
            debug.appendln("User actions");
            debug.indent();
            for (i = 0; i < userActions.length; ++i) {
                Dump.actionDetails(debug, userActions[i], 8, i);
            }
            debug.unindent();
            debug.appendln("Exploration actions");
            debug.indent();
            for (i = 0; i < explActions.length; ++i) {
                Dump.actionDetails(debug, explActions[i], 8, i);
            }
            debug.unindent();
            debug.appendln("Debug actions");
            debug.indent();
            for (i = 0; i < debActions.length; ++i) {
                Dump.actionDetails(debug, debActions[i], 8, i);
            }
            debug.unindent();
        }
    }

    private static void actionDetails(DebugString debug, NakedObjectAction a, int indent, int count) {
        debug.appendln(count + 1 + "." + a.getId() + " (" + a.getClass().getName() + ")");
        debug.indent();
        int newIndent = indent + 4;
        try {
            NakedObjectAction[] debActions = a.getActions();
            if (debActions.length > 0) {
                for (int i = 0; i < debActions.length; ++i) {
                    Dump.actionDetails(debug, debActions[i], newIndent, i);
                }
            } else {
                NakedObjectSpecification returnType;
                if (a.getDescription() != null && !a.getDescription().equals("")) {
                    debug.appendln("Description", (Object)a.getDescription());
                }
                debug.appendln("ID", (Object)a.getId());
                debug.appendln(a.debugData());
                debug.appendln("Target", (Object)a.getTarget());
                debug.appendln("On type", (Object)a.getOnType());
                Class[] facets = a.getFacetTypes();
                if (facets.length > 0) {
                    debug.appendln("Facets");
                    debug.indent();
                    for (int j = 0; j < facets.length; ++j) {
                        debug.appendln(a.getFacet(facets[j]).toString());
                    }
                    debug.unindent();
                }
                debug.appendln("Returns", (Object)((returnType = a.getReturnType()) == null ? "VOID" : returnType.toString()));
                NakedObjectActionParameter[] parameters = a.getParameters();
                if (parameters.length == 0) {
                    debug.appendln("Parameters", (Object)"none");
                } else {
                    debug.appendln("Parameters");
                    debug.indent();
                    NakedObjectActionParameter[] p = a.getParameters();
                    for (int j = 0; j < parameters.length; ++j) {
                        debug.append((Object)p[j].getName());
                        debug.append((Object)" (");
                        debug.append((Object)parameters[j].getSpecification().getFullName());
                        debug.appendln(")");
                        debug.indent();
                        Class[] parameterFacets = p[j].getFacetTypes();
                        for (int i = 0; i < parameterFacets.length; ++i) {
                            debug.appendln(p[j].getFacet(parameterFacets[i]).toString());
                        }
                        debug.unindent();
                    }
                    debug.unindent();
                }
            }
        }
        catch (RuntimeException e) {
            debug.appendException((Exception)e);
        }
        debug.unindent();
    }

    private static String[] specificationNames(NakedObjectSpecification[] specifications) {
        String[] names = new String[specifications.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = specifications[i].getFullName();
        }
        return names;
    }
}

