package org.nakedobjects.runtime.authentication.standard.singleuser;

import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.standard.AuthenticatorAbstract;
import org.nakedobjects.runtime.authentication.standard.exploration.AuthenticationRequestExploration;
import org.nakedobjects.runtime.system.DeploymentType;

/**
 * Creates a session suitable for {@link DeploymentType#SINGLE_USER single-user}
 * mode.
 */
public class SingleUserAuthenticator extends AuthenticatorAbstract {

	// //////////////////////////////////////////////////////////////////
	// Constructor
	// //////////////////////////////////////////////////////////////////

	public SingleUserAuthenticator(final NakedObjectConfiguration configuration) {
		super(configuration);
	}

	// //////////////////////////////////////////////////////////////////
	// API
	// //////////////////////////////////////////////////////////////////

	/**
	 * Can authenticate if a {@link AuthenticationRequestExploration}.
	 */
	public final boolean canAuthenticate(final AuthenticationRequest request) {
		return request instanceof AuthenticationRequestSingleUser;
	}

	/**
	 * Valid providing running in {@link DeploymentType#isExploring()
	 * exploration} mode.
	 */
	public final boolean isValid(final AuthenticationRequest request) {
		return getDeploymentType() == DeploymentType.SINGLE_USER;
	}

	@Override
	public AuthenticationSession authenticate(
			final AuthenticationRequest request,
			final String code) {
		return new SingleUserSession(code);
	}

}

// Copyright (c) Naked Objects Group Ltd.
