package org.nakedobjects.runtime.authorization.standard.ldap;

import org.nakedobjects.metamodel.config.ConfigurationConstants;
import org.nakedobjects.runtime.authorization.standard.AuthorizationConstants;

public final class LdapAuthorizationConstants {
	
	private static final String ROOT = ConfigurationConstants.ROOT + "authorization.ldap.";
	
	public static final String SERVER_IMPL_KEY = ROOT + "server";
	public static final String SERVER_IMPL_DEFAULT = "com.sun.jndi.ldap.LdapCtxFactory";
	
	public static final String DN_KEY = ROOT + "dn";
	
	public static final String APP_DN_KEY = ROOT + "application.dn";
	
	public static final String AUTH_LEARN_KEY = AuthorizationConstants.LEARN;
	public static final boolean AUTH_LEARN_DEFAULT = AuthorizationConstants.LEARN_DEFAULT;

	private LdapAuthorizationConstants() {}

}
