package org.nakedobjects.runtime.system;

import org.junit.Assert;
import org.junit.Test;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.specloader.JavaReflector;
import org.nakedobjects.runtime.testsystem.TestPojo;


public class JavaReflector_ArrayTest extends JavaReflectorTestAbstract {

    @Override
    protected NakedObjectSpecification loadSpecification(final JavaReflector reflector) {
        return reflector.loadSpecification(TestPojo[].class);
    }

    @Test
    public void testType() throws Exception {
        Assert.assertTrue(specification.isCollection());
    }

    @Test
    public void testName() throws Exception {
        Assert.assertEquals(TestPojo[].class.getName(), specification.getFullName());
    }

    @Test
    @Override
    public void testCollectionFacet() throws Exception {
        final Facet facet = specification.getFacet(CollectionFacet.class);
        Assert.assertNotNull(facet);
    }

    @Test
    @Override
    public void testTypeOfFacet() throws Exception {
        final TypeOfFacet facet = specification.getFacet(TypeOfFacet.class);
        Assert.assertNotNull(facet);
        Assert.assertEquals(TestPojo.class, facet.value());
    }

}

// Copyright (c) Naked Objects Group Ltd.
