/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.authentication.standard;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.standard.AuthenticatorAbstract;
import org.nakedobjects.runtime.system.DeploymentType;

@RunWith(value=JMock.class)
public class AuthenticatorAbstractTest {
    private Mockery mockery = new JUnit4Mockery();
    private NakedObjectConfiguration mockConfiguration;
    private AuthenticatorAbstract authenticator;

    @Before
    public void setUp() {
        this.mockConfiguration = (NakedObjectConfiguration)this.mockery.mock(NakedObjectConfiguration.class);
        this.authenticator = new AuthenticatorAbstract(this.mockConfiguration){

            public boolean canAuthenticate(AuthenticationRequest request) {
                return false;
            }

            public boolean isValid(AuthenticationRequest request) {
                return false;
            }
        };
    }

    @Test
    public void getConfiguration() throws Exception {
        Assert.assertThat((Object)this.authenticator.getConfiguration(), (Matcher)CoreMatchers.is((Object)this.mockConfiguration));
    }

    @Test
    public void getDeploymentTypeForExploration() throws Exception {
        final DeploymentType deploymentType = DeploymentType.EXPLORATION;
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(AuthenticatorAbstractTest.this.mockConfiguration)).getString("nakedobjects.deploymentType");
                this.will(2.returnValue((Object)deploymentType.name()));
            }
        });
        Assert.assertThat((Object)this.authenticator.getDeploymentType(), (Matcher)CoreMatchers.is((Object)deploymentType));
    }

    @Test
    public void getDeploymentTypeForPrototype() throws Exception {
        final DeploymentType deploymentType = DeploymentType.PROTOTYPE;
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(AuthenticatorAbstractTest.this.mockConfiguration)).getString("nakedobjects.deploymentType");
                this.will(3.returnValue((Object)deploymentType.name()));
            }
        });
        Assert.assertThat((Object)this.authenticator.getDeploymentType(), (Matcher)CoreMatchers.is((Object)deploymentType));
    }

    @Test
    public void getDeploymentTypeForServer() throws Exception {
        final DeploymentType deploymentType = DeploymentType.SERVER;
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(AuthenticatorAbstractTest.this.mockConfiguration)).getString("nakedobjects.deploymentType");
                this.will(4.returnValue((Object)deploymentType.name()));
            }
        });
        Assert.assertThat((Object)this.authenticator.getDeploymentType(), (Matcher)CoreMatchers.is((Object)deploymentType));
    }

    @Test(expected=IllegalStateException.class)
    public void expectsThereToBeADeploymentTypeInNakedObjectsConfiguration() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(AuthenticatorAbstractTest.this.mockConfiguration)).getString("nakedobjects.deploymentType");
                this.will(5.returnValue(null));
            }
        });
        this.authenticator.getDeploymentType();
    }

    @Test(expected=IllegalArgumentException.class)
    public void expectsThereToBeAValidDeploymentTypeInNakedObjectsConfiguration() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(AuthenticatorAbstractTest.this.mockConfiguration)).getString("nakedobjects.deploymentType");
                this.will(6.returnValue((Object)"GARBAGE"));
            }
        });
        this.authenticator.getDeploymentType();
    }
}

