/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.authentication.standard;

import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.standard.SimpleSession;
import org.nakedobjects.runtime.authentication.standard.exploration.AuthenticationRequestExploration;
import org.nakedobjects.runtime.authentication.standard.exploration.ExplorationAuthenticator;
import org.nakedobjects.runtime.authentication.standard.exploration.ExplorationSession;
import org.nakedobjects.runtime.authentication.standard.exploration.MultiUserExplorationSession;
import org.nakedobjects.runtime.system.DeploymentType;

@RunWith(value=JMock.class)
public class MultiUserExplorationSessionTest {
    private Mockery mockery = new JUnit4Mockery();
    private MultiUserExplorationSession session;
    private NakedObjectConfiguration mockConfiguration;
    private ExplorationAuthenticator authenticator;

    @Before
    public void setUp() {
        this.mockConfiguration = (NakedObjectConfiguration)this.mockery.mock(NakedObjectConfiguration.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(MultiUserExplorationSessionTest.this.mockConfiguration)).getString("nakedobjects.deploymentType");
                this.will(1.returnValue((Object)DeploymentType.EXPLORATION.name()));
            }
        });
    }

    @Test
    public void testNameDefaultsToFirstUser() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(MultiUserExplorationSessionTest.this.mockConfiguration)).getString("nakedobjects.exploration.users");
                this.will(2.returnValue((Object)"fred, sven:admin|sales|marketing, bob:sales, dick"));
            }
        });
        this.authenticator = new ExplorationAuthenticator(this.mockConfiguration);
        AuthenticationSession session = this.authenticator.authenticate((AuthenticationRequest)new AuthenticationRequestExploration(), "");
        junit.framework.Assert.assertEquals((String)"fred", (String)session.getUserName());
    }

    @Test
    public void testValidateCode() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(MultiUserExplorationSessionTest.this.mockConfiguration)).getString("nakedobjects.exploration.users");
                this.will(3.returnValue((Object)"fred, sven:admin|sales|marketing, bob:sales, dick"));
            }
        });
        this.authenticator = new ExplorationAuthenticator(this.mockConfiguration);
        AuthenticationSession session = this.authenticator.authenticate((AuthenticationRequest)new AuthenticationRequestExploration(), "xxx");
        junit.framework.Assert.assertEquals((String)"xxx", (String)session.getValidationCode());
    }

    @Test
    public void testNoRolesSpecifiedForFirstUser() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(MultiUserExplorationSessionTest.this.mockConfiguration)).getString("nakedobjects.exploration.users");
                this.will(4.returnValue((Object)"fred, sven:admin|sales|marketing, bob:sales, dick"));
            }
        });
        this.authenticator = new ExplorationAuthenticator(this.mockConfiguration);
        AuthenticationSession session = this.authenticator.authenticate((AuthenticationRequest)new AuthenticationRequestExploration(), "");
        junit.framework.Assert.assertEquals((int)0, (int)session.getRoles().size());
    }

    @Test
    public void testForMultipleUser() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(MultiUserExplorationSessionTest.this.mockConfiguration)).getString("nakedobjects.exploration.users");
                this.will(5.returnValue((Object)"fred, sven:admin|sales|marketing, bob:sales, dick"));
            }
        });
        this.authenticator = new ExplorationAuthenticator(this.mockConfiguration);
        AuthenticationSession authSession = this.authenticator.authenticate((AuthenticationRequest)new AuthenticationRequestExploration(), "");
        Assert.assertThat((Object)authSession, (Matcher)CoreMatchers.is(MultiUserExplorationSession.class));
        Assert.assertThat((Object)authSession.getUserName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"fred")));
    }

    @Test
    public void testForSingleUser() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(MultiUserExplorationSessionTest.this.mockConfiguration)).getString("nakedobjects.exploration.users");
                this.will(6.returnValue((Object)"sven"));
            }
        });
        this.authenticator = new ExplorationAuthenticator(this.mockConfiguration);
        AuthenticationSession authSession = this.authenticator.authenticate((AuthenticationRequest)new AuthenticationRequestExploration(), "");
        Assert.assertThat((Object)authSession, (Matcher)CoreMatchers.is(SimpleSession.class));
        Assert.assertThat((Object)authSession.getUserName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"sven")));
    }

    @Test
    public void testNoUsersSpecified() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(MultiUserExplorationSessionTest.this.mockConfiguration)).getString("nakedobjects.exploration.users");
                this.will(7.returnValue(null));
            }
        });
        this.authenticator = new ExplorationAuthenticator(this.mockConfiguration);
        AuthenticationSession authSession = this.authenticator.authenticate((AuthenticationRequest)new AuthenticationRequestExploration(), "");
        Assert.assertThat((Object)authSession, (Matcher)CoreMatchers.is(ExplorationSession.class));
    }

    @Test
    public void testOtherUsers() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(MultiUserExplorationSessionTest.this.mockConfiguration)).getString("nakedobjects.exploration.users");
                this.will(8.returnValue((Object)"fred, sven:admin|sales|marketing, bob:sales, dick"));
            }
        });
        this.authenticator = new ExplorationAuthenticator(this.mockConfiguration);
        this.session = (MultiUserExplorationSession)this.authenticator.authenticate((AuthenticationRequest)new AuthenticationRequestExploration(), "");
        Set availableSessions = this.session.getUserNames();
        junit.framework.Assert.assertEquals((int)4, (int)availableSessions.size());
        junit.framework.Assert.assertTrue((boolean)availableSessions.contains("fred"));
        junit.framework.Assert.assertTrue((boolean)availableSessions.contains("sven"));
        junit.framework.Assert.assertTrue((boolean)availableSessions.contains("bob"));
        junit.framework.Assert.assertTrue((boolean)availableSessions.contains("dick"));
    }

    @Test
    public void testChangeUser() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(MultiUserExplorationSessionTest.this.mockConfiguration)).getString("nakedobjects.exploration.users");
                this.will(9.returnValue((Object)"fred, sven:admin|sales|marketing, bob:sales, dick"));
            }
        });
        this.authenticator = new ExplorationAuthenticator(this.mockConfiguration);
        this.session = (MultiUserExplorationSession)this.authenticator.authenticate((AuthenticationRequest)new AuthenticationRequestExploration(), "");
        this.session.setCurrentSession("bob");
        junit.framework.Assert.assertEquals((String)"bob", (String)this.session.getUserName());
    }

    @Test
    public void testRolesExist() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(MultiUserExplorationSessionTest.this.mockConfiguration)).getString("nakedobjects.exploration.users");
                this.will(10.returnValue((Object)"fred, sven:admin|sales|marketing, bob:sales, dick"));
            }
        });
        this.authenticator = new ExplorationAuthenticator(this.mockConfiguration);
        this.session = (MultiUserExplorationSession)this.authenticator.authenticate((AuthenticationRequest)new AuthenticationRequestExploration(), "");
        this.session.setCurrentSession("sven");
        List roles = this.session.getRoles();
        junit.framework.Assert.assertEquals((int)3, (int)roles.size());
        junit.framework.Assert.assertEquals((String)"admin", (String)((String)roles.get(0)));
        junit.framework.Assert.assertEquals((String)"sales", (String)((String)roles.get(1)));
        junit.framework.Assert.assertEquals((String)"marketing", (String)((String)roles.get(2)));
    }
}

