/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.authentication.standard;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.AuthenticationRequestPassword;
import org.nakedobjects.runtime.authentication.standard.AuthenticationManagerStandard;
import org.nakedobjects.runtime.authentication.standard.Authenticator;
import org.nakedobjects.runtime.authentication.standard.RandomCodeGenerator;

@RunWith(value=JMock.class)
public class StandardAuthenticationManager_AuthenticationTest {
    private Mockery mockery = new JUnit4Mockery();
    private AuthenticationManagerStandard authenticationManager;
    private NakedObjectConfiguration mockConfiguration;
    private RandomCodeGenerator mockRandomCodeGenerator;
    private Authenticator mockAuthenticator;
    private AuthenticationSession mockAuthSession;

    @Before
    public void setUp() throws Exception {
        this.mockConfiguration = (NakedObjectConfiguration)this.mockery.mock(NakedObjectConfiguration.class);
        this.mockRandomCodeGenerator = (RandomCodeGenerator)this.mockery.mock(RandomCodeGenerator.class);
        this.mockAuthenticator = (Authenticator)this.mockery.mock(Authenticator.class);
        this.mockAuthSession = (AuthenticationSession)this.mockery.mock(AuthenticationSession.class);
        this.authenticationManager = new AuthenticationManagerStandard(this.mockConfiguration);
        this.authenticationManager.addAuthenticator(this.mockAuthenticator);
        this.authenticationManager.setRandomCodeGenerator(this.mockRandomCodeGenerator);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((Authenticator)this.allowing(StandardAuthenticationManager_AuthenticationTest.this.mockAuthenticator)).canAuthenticate((AuthenticationRequest)this.with(1.any(AuthenticationRequest.class)));
                this.will(1.returnValue((Object)true));
                ((Authenticator)this.allowing(StandardAuthenticationManager_AuthenticationTest.this.mockAuthenticator)).authenticate((AuthenticationRequest)this.with(1.any(AuthenticationRequest.class)), (String)this.with(1.any(String.class)));
                this.will(1.returnValue((Object)StandardAuthenticationManager_AuthenticationTest.this.mockAuthSession));
                ((RandomCodeGenerator)this.allowing(StandardAuthenticationManager_AuthenticationTest.this.mockRandomCodeGenerator)).generateRandomCode();
                this.will(1.returnValue((Object)"123456"));
                ((AuthenticationSession)this.allowing(StandardAuthenticationManager_AuthenticationTest.this.mockAuthSession)).getValidationCode();
                this.will(1.returnValue((Object)"123456"));
                ((AuthenticationSession)this.allowing(StandardAuthenticationManager_AuthenticationTest.this.mockAuthSession)).hasUserNameOf("foo");
                this.will(1.returnValue((Object)true));
                ((AuthenticationSession)this.allowing(StandardAuthenticationManager_AuthenticationTest.this.mockAuthSession)).getUserName();
                this.will(1.returnValue((Object)"foo"));
            }
        });
    }

    @Test
    public void newlyCreatedAuthenticationSessionShouldBeValid() throws Exception {
        AuthenticationRequestPassword request = new AuthenticationRequestPassword("foo", "bar");
        AuthenticationSession session = this.authenticationManager.authenticate((AuthenticationRequest)request);
        Assert.assertThat((Object)this.authenticationManager.isSessionValid(session), (Matcher)CoreMatchers.is((Object)true));
    }
}

