/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.authentication.standard;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.AuthenticationRequestPassword;
import org.nakedobjects.runtime.authentication.NoAuthenticatorException;
import org.nakedobjects.runtime.authentication.standard.AuthenticationManagerStandard;
import org.nakedobjects.runtime.authentication.standard.Authenticator;
import org.nakedobjects.runtime.authentication.standard.noop.AuthenticatorNoop;

@RunWith(value=JMock.class)
public class StandardAuthenticationManager_AuthenticatorsTest {
    private Mockery mockery = new JUnit4Mockery();
    private NakedObjectConfiguration mockConfiguration;
    private AuthenticationManagerStandard authenticationManager;

    @Before
    public void setUp() throws Exception {
        this.mockConfiguration = (NakedObjectConfiguration)this.mockery.mock(NakedObjectConfiguration.class);
        this.authenticationManager = new AuthenticationManagerStandard(this.mockConfiguration);
    }

    @Test
    public void shouldInitiallyHaveNoAuthenticators() throws Exception {
        Assert.assertThat((Object)this.authenticationManager.getAuthenticators().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test(expected=NoAuthenticatorException.class)
    public void shouldNotBeAbleToAuthenticateWithNoAuthenticators() throws Exception {
        this.authenticationManager.authenticate((AuthenticationRequest)new AuthenticationRequestPassword("foo", "bar"));
    }

    @Test
    public void shouldBeAbleToAddAuthenticators() throws Exception {
        AuthenticatorNoop authenticator = new AuthenticatorNoop(this.mockConfiguration);
        this.authenticationManager.addAuthenticator((Authenticator)authenticator);
        Assert.assertThat((Object)this.authenticationManager.getAuthenticators().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(this.authenticationManager.getAuthenticators().get(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)authenticator)));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldNotBeAbleToModifyReturnedAuthenticators() throws Exception {
        List authenticators = this.authenticationManager.getAuthenticators();
        authenticators.add(new AuthenticatorNoop(this.mockConfiguration));
    }
}

