/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.authentication.standard.exploration;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.AuthenticationRequestAbstract;
import org.nakedobjects.runtime.authentication.standard.exploration.AuthenticationRequestExploration;
import org.nakedobjects.runtime.authentication.standard.exploration.ExplorationAuthenticator;
import org.nakedobjects.runtime.system.DeploymentType;

@RunWith(value=JMock.class)
public class ExplorationAuthenticatorTest {
    private Mockery mockery = new JUnit4Mockery();
    private NakedObjectConfiguration mockConfiguration;
    private ExplorationAuthenticator authenticator;
    private AuthenticationRequestExploration explorationRequest;
    private SomeOtherAuthenticationRequest someOtherRequest;

    @Before
    public void setUp() {
        this.mockConfiguration = (NakedObjectConfiguration)this.mockery.mock(NakedObjectConfiguration.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(ExplorationAuthenticatorTest.this.mockConfiguration)).getString("nakedobjects.exploration.users");
                this.will(1.returnValue((Object)DeploymentType.EXPLORATION.name()));
            }
        });
        this.explorationRequest = new AuthenticationRequestExploration();
        this.someOtherRequest = new SomeOtherAuthenticationRequest();
        this.authenticator = new ExplorationAuthenticator(this.mockConfiguration);
    }

    @Test
    public void canAuthenticateExplorationRequest() throws Exception {
        Assert.assertThat((Object)this.authenticator.canAuthenticate((AuthenticationRequest)this.explorationRequest), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void canAuthenticateSomeOtherTypeOfRequest() throws Exception {
        Assert.assertThat((Object)this.authenticator.canAuthenticate((AuthenticationRequest)this.someOtherRequest), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void isValidExplorationRequestWhenRunningInExplorationMode() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(ExplorationAuthenticatorTest.this.mockConfiguration)).getString("nakedobjects.deploymentType");
                this.will(2.returnValue((Object)DeploymentType.EXPLORATION.name()));
            }
        });
        Assert.assertThat((Object)this.authenticator.isValid((AuthenticationRequest)this.explorationRequest), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void isNotValidExplorationRequestWhenRunningInSomethingOtherThanExplorationMode() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(ExplorationAuthenticatorTest.this.mockConfiguration)).getString("nakedobjects.deploymentType");
                this.will(3.returnValue((Object)DeploymentType.PROTOTYPE.name()));
            }
        });
        Assert.assertThat((Object)this.authenticator.isValid((AuthenticationRequest)this.explorationRequest), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=IllegalStateException.class)
    public void expectsThereToBeADeploymentTypeInNakedObjectsConfiguration() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(ExplorationAuthenticatorTest.this.mockConfiguration)).getString("nakedobjects.deploymentType");
                this.will(4.returnValue(null));
            }
        });
        this.authenticator.isValid((AuthenticationRequest)this.explorationRequest);
    }

    @Test
    public void isValidSomeOtherTypeOfRequest() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(ExplorationAuthenticatorTest.this.mockConfiguration)).getString("nakedobjects.deploymentType");
                this.will(5.returnValue((Object)DeploymentType.EXPLORATION.name()));
            }
        });
        Assert.assertThat((Object)this.authenticator.canAuthenticate((AuthenticationRequest)this.someOtherRequest), (Matcher)CoreMatchers.is((Object)false));
    }

    private static class SomeOtherAuthenticationRequest
    extends AuthenticationRequestAbstract {
        public SomeOtherAuthenticationRequest() {
            super("other");
        }
    }
}

