/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.authentication.standard.fixture;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.applib.fixtures.LogonFixture;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.AuthenticationRequestAbstract;
import org.nakedobjects.runtime.authentication.standard.fixture.AuthenticationRequestLogonFixture;
import org.nakedobjects.runtime.authentication.standard.fixture.LogonFixtureAuthenticator;
import org.nakedobjects.runtime.system.DeploymentType;

@RunWith(value=JMock.class)
public class LogonFixtureAuthenticatorTest {
    private Mockery mockery = new JUnit4Mockery();
    private NakedObjectConfiguration mockConfiguration;
    private LogonFixtureAuthenticator authenticator;
    private AuthenticationRequestLogonFixture logonFixtureRequest;
    private SomeOtherAuthenticationRequest someOtherRequest;

    @Before
    public void setUp() {
        this.mockConfiguration = (NakedObjectConfiguration)this.mockery.mock(NakedObjectConfiguration.class);
        this.logonFixtureRequest = new AuthenticationRequestLogonFixture(new LogonFixture("joebloggs", new String[0]));
        this.someOtherRequest = new SomeOtherAuthenticationRequest();
        this.authenticator = new LogonFixtureAuthenticator(this.mockConfiguration);
    }

    @Test
    public void canAuthenticateExplorationRequest() throws Exception {
        Assert.assertThat((Object)this.authenticator.canAuthenticate((AuthenticationRequest)this.logonFixtureRequest), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void canAuthenticateSomeOtherTypeOfRequest() throws Exception {
        Assert.assertThat((Object)this.authenticator.canAuthenticate((AuthenticationRequest)this.someOtherRequest), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void isValidLogonFixtureRequestWhenRunningInExplorationMode() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(LogonFixtureAuthenticatorTest.this.mockConfiguration)).getString("nakedobjects.deploymentType");
                this.will(1.returnValue((Object)DeploymentType.EXPLORATION.name()));
            }
        });
        Assert.assertThat((Object)this.authenticator.isValid((AuthenticationRequest)this.logonFixtureRequest), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void isValidLogonFixtureRequestWhenRunningInPrototypeMode() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(LogonFixtureAuthenticatorTest.this.mockConfiguration)).getString("nakedobjects.deploymentType");
                this.will(2.returnValue((Object)DeploymentType.PROTOTYPE.name()));
            }
        });
        Assert.assertThat((Object)this.authenticator.isValid((AuthenticationRequest)this.logonFixtureRequest), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void isNotValidExplorationRequestWhenRunningInSomethingOtherThanExplorationOrPrototypeMode() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(LogonFixtureAuthenticatorTest.this.mockConfiguration)).getString("nakedobjects.deploymentType");
                this.will(3.returnValue((Object)DeploymentType.SERVER.name()));
            }
        });
        Assert.assertThat((Object)this.authenticator.isValid((AuthenticationRequest)this.logonFixtureRequest), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=IllegalStateException.class)
    public void expectsThereToBeADeploymentTypeInNakedObjectsConfiguration() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(LogonFixtureAuthenticatorTest.this.mockConfiguration)).getString("nakedobjects.deploymentType");
                this.will(4.returnValue(null));
            }
        });
        this.authenticator.isValid((AuthenticationRequest)this.logonFixtureRequest);
    }

    @Test
    public void isValidSomeOtherTypeOfRequest() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(LogonFixtureAuthenticatorTest.this.mockConfiguration)).getString("nakedobjects.deploymentType");
                this.will(5.returnValue((Object)DeploymentType.EXPLORATION.name()));
            }
        });
        Assert.assertThat((Object)this.authenticator.canAuthenticate((AuthenticationRequest)new SomeOtherAuthenticationRequest()), (Matcher)CoreMatchers.is((Object)false));
    }

    private static class SomeOtherAuthenticationRequest
    extends AuthenticationRequestAbstract {
        public SomeOtherAuthenticationRequest() {
            super("other");
        }
    }
}

