/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.context;

import java.util.Collections;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.config.internal.PropertiesConfiguration;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.specloader.NakedObjectReflector;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.authorization.AuthorizationManager;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.context.NakedObjectsContextStatic;
import org.nakedobjects.runtime.imageloader.TemplateImageLoader;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.persistence.internal.RuntimeContextFromSession;
import org.nakedobjects.runtime.session.NakedObjectSessionFactory;
import org.nakedobjects.runtime.session.NakedObjectSessionFactoryDefault;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.testsystem.TestProxyPersistenceSession;
import org.nakedobjects.runtime.testsystem.TestProxyReflector;
import org.nakedobjects.runtime.testsystem.TestProxySession;
import org.nakedobjects.runtime.userprofile.UserProfile;
import org.nakedobjects.runtime.userprofile.UserProfileLoader;

@RunWith(value=JMock.class)
public class NakedObjectsContextTest {
    private Mockery mockery = new JUnit4Mockery();
    private NakedObjectConfiguration configuration;
    private PersistenceSession persistenceSession;
    private NakedObjectReflector reflector;
    private TestProxySession session;
    protected TemplateImageLoader mockTemplateImageLoader;
    protected PersistenceSessionFactory mockPersistenceSessionFactory;
    private UserProfileLoader mockUserProfileLoader;
    protected AuthenticationManager mockAuthenticationManager;
    protected AuthorizationManager mockAuthorizationManager;
    private List<Object> servicesList;

    @Before
    public void setUp() throws Exception {
        NakedObjectsContext.testReset();
        this.servicesList = Collections.emptyList();
        this.mockTemplateImageLoader = (TemplateImageLoader)this.mockery.mock(TemplateImageLoader.class);
        this.mockPersistenceSessionFactory = (PersistenceSessionFactory)this.mockery.mock(PersistenceSessionFactory.class);
        this.mockUserProfileLoader = (UserProfileLoader)this.mockery.mock(UserProfileLoader.class);
        this.mockAuthenticationManager = (AuthenticationManager)this.mockery.mock(AuthenticationManager.class);
        this.mockAuthorizationManager = (AuthorizationManager)this.mockery.mock(AuthorizationManager.class);
        this.configuration = new PropertiesConfiguration();
        this.reflector = new TestProxyReflector();
        this.persistenceSession = new TestProxyPersistenceSession(this.mockPersistenceSessionFactory);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((PersistenceSessionFactory)this.one(NakedObjectsContextTest.this.mockPersistenceSessionFactory)).createPersistenceSession();
                this.will(1.returnValue((Object)NakedObjectsContextTest.this.persistenceSession));
                this.ignoring(NakedObjectsContextTest.this.mockPersistenceSessionFactory);
                ((UserProfileLoader)this.one(NakedObjectsContextTest.this.mockUserProfileLoader)).getProfile((AuthenticationSession)this.with(1.any(AuthenticationSession.class)));
                this.will(1.returnValue((Object)new UserProfile()));
                this.ignoring(NakedObjectsContextTest.this.mockUserProfileLoader);
                this.ignoring(NakedObjectsContextTest.this.mockAuthenticationManager);
                this.ignoring(NakedObjectsContextTest.this.mockAuthorizationManager);
                this.ignoring(NakedObjectsContextTest.this.mockTemplateImageLoader);
            }
        });
        this.reflector.setRuntimeContext((RuntimeContext)new RuntimeContextFromSession());
        NakedObjectsContext.setConfiguration((NakedObjectConfiguration)this.configuration);
        NakedObjectSessionFactoryDefault sessionFactory = new NakedObjectSessionFactoryDefault(DeploymentType.EXPLORATION, this.configuration, this.mockTemplateImageLoader, (SpecificationLoader)this.reflector, this.mockAuthenticationManager, this.mockAuthorizationManager, this.mockUserProfileLoader, this.mockPersistenceSessionFactory, this.servicesList);
        NakedObjectsContextStatic.createRelaxedInstance((NakedObjectSessionFactory)sessionFactory);
        sessionFactory.init();
        this.session = new TestProxySession();
        NakedObjectsContext.openSession((AuthenticationSession)this.session);
    }

    @Test
    public void testConfiguration() {
        Assert.assertEquals((Object)this.configuration, (Object)NakedObjectsContext.getConfiguration());
    }

    @Test
    public void testObjectPersistor() {
        Assert.assertEquals((Object)this.persistenceSession, (Object)NakedObjectsContext.getPersistenceSession());
    }

    @Test
    public void testSpecificationLoader() {
        Assert.assertEquals((Object)this.reflector, (Object)NakedObjectsContext.getSpecificationLoader());
    }

    @Test
    public void testSession() {
        Assert.assertEquals((Object)((Object)this.session), (Object)NakedObjectsContext.getAuthenticationSession());
    }
}

