/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.runtime.help.file;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.config.internal.PropertiesConfiguration;
import org.nakedobjects.runtime.help.file.FileBasedHelpManager;
import org.nakedobjects.runtime.help.file.TestHelpManager;

public class SimpleHelpManagerTest
extends TestCase {
    private TestHelpManager manager;

    public static void main(String[] args) {
        TestRunner.run(SimpleHelpManagerTest.class);
    }

    protected void setUp() throws Exception {
        this.manager = new TestHelpManager((NakedObjectConfiguration)new PropertiesConfiguration());
    }

    public void testNoLines() {
        Identifier identifier = Identifier.propertyOrCollectionIdentifier((String)"cls", (String)"mth");
        String s = this.manager.help(identifier);
        SimpleHelpManagerTest.assertEquals((String)"", (String)s);
    }

    public void testClass() {
        this.manager.addLine("C:cls");
        this.manager.addLine("Help about class");
        Identifier identifier = Identifier.classIdentifier((String)"cls");
        String s = this.manager.help(identifier);
        SimpleHelpManagerTest.assertEquals((String)"Help about class\n", (String)s);
    }

    public void testClassWithNoText() {
        this.manager.addLine("C:cls");
        this.manager.addLine("C:cls2");
        this.manager.addLine("Help about class");
        Identifier identifier = Identifier.classIdentifier((String)"cls");
        String s = this.manager.help(identifier);
        SimpleHelpManagerTest.assertEquals((String)"", (String)s);
    }

    public void testClassTextStopsAtNextClass() {
        this.manager.addLine("C:cls");
        this.manager.addLine("Help about class");
        this.manager.addLine("C:cls2");
        this.manager.addLine("Different text");
        Identifier identifier = Identifier.classIdentifier((String)"cls");
        String s = this.manager.help(identifier);
        SimpleHelpManagerTest.assertEquals((String)"Help about class\n", (String)s);
    }

    public void testMethodTextStopsAtNextClass() {
        this.manager.addLine("C:cls");
        this.manager.addLine("M:fld");
        this.manager.addLine("Help about method");
        this.manager.addLine("C:cls2");
        this.manager.addLine("Different text");
        Identifier identifier = Identifier.propertyOrCollectionIdentifier((String)"cls", (String)"fld");
        String s = this.manager.help(identifier);
        SimpleHelpManagerTest.assertEquals((String)"Help about method\n", (String)s);
    }

    public void testMethodTextStopsAtNextMethod() {
        this.manager.addLine("C:cls");
        this.manager.addLine("M:fld");
        this.manager.addLine("Help about method");
        this.manager.addLine("M:fld2");
        this.manager.addLine("Different text");
        Identifier identifier = Identifier.propertyOrCollectionIdentifier((String)"cls", (String)"fld");
        String s = this.manager.help(identifier);
        SimpleHelpManagerTest.assertEquals((String)"Help about method\n", (String)s);
    }

    public void testClassTextStopsAtFirstMethod() {
        this.manager.addLine("C:cls");
        this.manager.addLine("Help about class");
        this.manager.addLine("M:method");
        this.manager.addLine("Different text");
        Identifier identifier = Identifier.classIdentifier((String)"cls");
        String s = this.manager.help(identifier);
        SimpleHelpManagerTest.assertEquals((String)"Help about class\n", (String)s);
    }

    public void testEntryWithMultipleLines() {
        this.manager.addLine("C:cls");
        this.manager.addLine("Help about class");
        this.manager.addLine("line 2");
        this.manager.addLine("line 3");
        Identifier identifier = Identifier.classIdentifier((String)"cls");
        String s = this.manager.help(identifier);
        SimpleHelpManagerTest.assertEquals((String)"Help about class\nline 2\nline 3\n", (String)s);
    }

    public void testFieldWithNoEntry() {
        this.manager.addLine("C:cls");
        this.manager.addLine("Help about class");
        Identifier identifier = Identifier.propertyOrCollectionIdentifier((String)"cls", (String)"fld2");
        String s = this.manager.help(identifier);
        SimpleHelpManagerTest.assertEquals((String)"", (String)s);
    }

    public void testMessageForFileError() {
        Identifier identifier = Identifier.propertyOrCollectionIdentifier((String)"cls", (String)"fld2");
        FileBasedHelpManager manager = new FileBasedHelpManager((NakedObjectConfiguration)new PropertiesConfiguration()){

            protected BufferedReader getReader() throws FileNotFoundException {
                throw new FileNotFoundException("not found");
            }
        };
        String s = manager.help(identifier);
        SimpleHelpManagerTest.assertEquals((String)"Failure opening help file: not found", (String)s);
    }

    public void testField() {
        this.manager.addLine("C:cls");
        this.manager.addLine("Help about class");
        this.manager.addLine("M:fld1");
        this.manager.addLine("Help about field");
        this.manager.addLine("M:fld2");
        this.manager.addLine("Help about second field");
        Identifier identifier = Identifier.propertyOrCollectionIdentifier((String)"cls", (String)"fld2");
        String s = this.manager.help(identifier);
        SimpleHelpManagerTest.assertEquals((String)"Help about second field\n", (String)s);
    }

    public void testReadBlankLines() {
        this.manager.addLine("C:cls");
        this.manager.addLine("");
        this.manager.addLine("");
        this.manager.addLine("Help about class");
        Identifier identifier = Identifier.classIdentifier((String)"cls");
        String s = this.manager.help(identifier);
        SimpleHelpManagerTest.assertEquals((String)"\n\nHelp about class\n", (String)s);
    }

    public void testSkipComments() {
        this.manager.addLine("C:cls");
        this.manager.addLine("# comment");
        this.manager.addLine("Help about class");
        Identifier identifier = Identifier.classIdentifier((String)"cls");
        String s = this.manager.help(identifier);
        SimpleHelpManagerTest.assertEquals((String)"Help about class\n", (String)s);
    }
}

